﻿/**
© Florian Joncour, 2013-2018 florian@zetta-sys.com

Ce logiciel est un programme informatique faisant interface à la bibliothèque
Perspective3D, un outil de modélisation 3D à partir de vues orthographiques 2D.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée.  Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard  l'attention de l'utilisateur est attirée sur les risques
associés au chargement,  à l'utilisation,  à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invités à charger  et  tester  l'adéquation  du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.
**/

/* Objet: Style de décoration de fenêtres. */

#ifndef STYLE_H
#define STYLE_H

#include <QApplication>
#include <QWidget>
#include <QFrame>
#include <QFile>

/* Hauteur de la barre de la console et des propriétés des vues 2D/3D */
#define TAILLE_Y_CONSOLE_2D 75

template<typename T> void ChargeStyle(T &t, const char *feuille_style)
{
    QFile f_rc(feuille_style);
    f_rc.open(QFile::ReadOnly | QFile::Text);
    t.setStyleSheet(QString::fromUtf8(f_rc.readAll()));
    f_rc.close();
}

template<typename T> void ChargeStyle2(T &t, const char *feuille_style, const char *couleur_fond=nullptr)
{
    QFile f_rc(feuille_style);
    f_rc.open(QFile::ReadOnly | QFile::Text);
    QByteArray tampon = f_rc.readAll();
    if (couleur_fond)
    {
        tampon.replace("#1e252f", couleur_fond);
    }
    t.setStyleSheet(QString::fromUtf8(tampon));
    f_rc.close();
}

inline void ChargeStyleApp(QApplication &app, int id_style=1)
{
    if (id_style == 1)
    {
        ChargeStyle<QApplication>(app, ":/style/style-bd.qss");
    }
    else if (id_style == 2)
    {
        ChargeStyle<QApplication>(app, ":/style/style.qss");
    }
    else
    {
    }
}

inline void ChargeStyleWidget(QWidget &w, int id_style=1, const char *couleur_fond=nullptr)
{
    if (id_style == 1)
    {
        ChargeStyle<QWidget>(w, ":/style/style_w-bd.qss");
    }
    else if (id_style == 2)
    {
        ChargeStyle<QWidget>(w, ":/style/style_w.qss");
    }
    else if (id_style == 3)
    {
        ChargeStyle2<QWidget>(w, ":/style/style_w3d.qss", couleur_fond); /* Spécialement pour l'interface 3D. */
    }
    else if (id_style == 4)
    {
        ChargeStyle<QWidget>(w, ":/style/style_w2d.qss"); /* Spécialement pour l'interface 2D. */
    }
    else if (id_style == 5)
    {
        ChargeStyle<QWidget>(w, ":/style/BFenetrage-bd.qss"); /* Spécialement pour le fenêtrage. */
    }
    else
    {
    }
}

inline void ChargeStyleWidget(QWidget *w, int id_style=1, const char *couleur_fond=nullptr)
{
    if (w)
    {
        ChargeStyleWidget(*w, id_style, couleur_fond);
    }
}

#endif // STYLE_H
