﻿/**
© Florian Joncour, 2013-2018 florian@zetta-sys.com

Ce logiciel est un programme informatique faisant interface à la bibliothèque
Perspective3D, un outil de modélisation 3D à partir de vues orthographiques 2D.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée.  Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard  l'attention de l'utilisateur est attirée sur les risques
associés au chargement,  à l'utilisation,  à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invités à charger  et  tester  l'adéquation  du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.
**/

/* Objet: Barre des outils 3D (une par modèle 3D) */

#ifndef BARREOUTILS3D_H
#define BARREOUTILS3D_H

#include <QApplication>
#include <QToolButton>
#include <QHBoxLayout>
#include <QIcon>
#include <QFrame>

#include "style.h"

class BarreOutils3D
{
    public:
        inline BarreOutils3D():
            vueface(nullptr), vuecote(nullptr), vuehaut(nullptr), vuearriere(nullptr), vuegauche(nullptr), vuedessous(nullptr), vueperspective(nullptr), projections(nullptr), gen_patron(nullptr),
            export_fichier(nullptr), export_fichier_2d(nullptr), export_script(nullptr), imprime_fichier(nullptr), export_image_modele(nullptr), proprietes3d(nullptr)
#ifdef SUPPORT_GIF
          , export_animation_modele(nullptr)
#endif // SUPPORT_GIF
          /* , espacement1(0), espacement2(0), separateur(0) */
        { ; }

        inline void setupUi(QHBoxLayout *layout_w3d, QHBoxLayout *layout_wexport, bool mode_2d, QWidget *parent=0)
        {
            QSize taille_icone(32, 32);

            vueperspective = new QToolButton(parent);
            vueperspective->setObjectName("vueperspective");
            QIcon icone_perspective;
            icone_perspective.addFile(":/icones/cube_perspective.png", QSize(), QIcon::Normal, QIcon::Off);
            vueperspective->setIcon(icone_perspective);
            vueperspective->setAutoRaise(true);
            vueperspective->setIconSize(taille_icone);
            vueperspective->setShortcut(QKeySequence(Qt::CTRL+(Qt::Key_0 | Qt::KeypadModifier)));
            vueperspective->setToolTip(QApplication::translate("BarreOutils3D", "Vue oblique"));
            layout_w3d->addWidget(vueperspective);

            vueface = new QToolButton(parent);
            vueface->setObjectName("vueface");
            QIcon icone_face;
            if (!mode_2d)
            {
                icone_face.addFile(":/icones/cube_face.png", QSize(), QIcon::Normal, QIcon::Off);
            }
            else
            {
                icone_face.addFile(":/icones/vueface.png", QSize(), QIcon::Normal, QIcon::Off);
            }

            vueface->setIcon(icone_face);
            vueface->setAutoRaise(true);
            vueface->setIconSize(taille_icone);
            vueface->setShortcut(QKeySequence(Qt::CTRL+(Qt::Key_5 | Qt::KeypadModifier)));
            vueface->setToolTip(QApplication::translate("BarreOutils3D", "Vue de face"));
            layout_w3d->addWidget(vueface);

            if (!mode_2d)
            {
                vuearriere = new QToolButton(parent);
                vuearriere->setObjectName("vuearriere");
                QIcon icone_arriere;
                icone_arriere.addFile(":/icones/cube_arriere.png", QSize(), QIcon::Normal, QIcon::Off);
                vuearriere->setIcon(icone_arriere);
                vuearriere->setAutoRaise(true);
                vuearriere->setIconSize(taille_icone);
//                vuearriere->setShortcut(QKeySequence(Qt::CTRL+(Qt::Key_5 | Qt::KeypadModifier)));
                vuearriere->setToolTip(QApplication::translate("BarreOutils3D", "Vue arrière"));
                layout_w3d->addWidget(vuearriere);

                vuecote = new QToolButton(parent);
                vuecote->setObjectName("vuecote");
                QIcon icone_cote;
                icone_cote.addFile(":/icones/cube_cote.png", QSize(), QIcon::Normal, QIcon::Off);
                vuecote->setIcon(icone_cote);
                vuecote->setAutoRaise(true);
                vuecote->setIconSize(taille_icone);
                vuecote->setShortcut(QKeySequence(Qt::CTRL+(Qt::Key_6 | Qt::KeypadModifier)));
                vuecote->setToolTip(QApplication::translate("BarreOutils3D", "Vue de côté"));
                layout_w3d->addWidget(vuecote);

                vuegauche = new QToolButton(parent);
                vuegauche->setObjectName("vuegauche");
                QIcon icone_gauche;
                icone_gauche.addFile(":/icones/cube_gauche.png", QSize(), QIcon::Normal, QIcon::Off);
                vuegauche->setIcon(icone_gauche);
                vuegauche->setAutoRaise(true);
                vuegauche->setIconSize(taille_icone);
                vuegauche->setShortcut(QKeySequence(Qt::CTRL+(Qt::Key_4 | Qt::KeypadModifier)));
                vuegauche->setToolTip(QApplication::translate("BarreOutils3D", "Vue gauche"));
                layout_w3d->addWidget(vuegauche);

                vuehaut = new QToolButton(parent);
                vuehaut->setObjectName("vuehaut");
                QIcon icone_haut;
                icone_haut.addFile(":/icones/cube_haut.png", QSize(), QIcon::Normal, QIcon::Off);
                vuehaut->setIcon(icone_haut);
                vuehaut->setAutoRaise(true);
                vuehaut->setIconSize(taille_icone);
                vuehaut->setShortcut(QKeySequence(Qt::CTRL+(Qt::Key_8 | Qt::KeypadModifier)));
                vuehaut->setToolTip(QApplication::translate("BarreOutils3D", "Vue de dessus"));
                layout_w3d->addWidget(vuehaut);

                vuedessous = new QToolButton(parent);
                vuedessous->setObjectName("vuedessous");
                QIcon icone_dessous;
                icone_dessous.addFile(":/icones/cube_dessous.png", QSize(), QIcon::Normal, QIcon::Off);
                vuedessous->setIcon(icone_dessous);
                vuedessous->setAutoRaise(true);
                vuedessous->setIconSize(taille_icone);
                vuedessous->setShortcut(QKeySequence(Qt::CTRL+(Qt::Key_2 | Qt::KeypadModifier)));
                vuedessous->setToolTip(QApplication::translate("BarreOutils3D", "Vue de dessous"));
                layout_w3d->addWidget(vuedessous);

//                projections = new QToolButton(parent);
//                projections->setObjectName("afficheprojections");
//                QIcon icone_projections;
//                icone_projections.addFile(":/icones/projections1.png", QSize(), QIcon::Normal, QIcon::Off);
//                projections->setIcon(icone_projections);
//                projections->setAutoRaise(true);
//                projections->setIconSize(taille_icone);
//                projections->setShortcut(QKeySequence(Qt::CTRL+(Qt::Key_Plus | Qt::KeypadModifier)));
//                projections->setToolTip(QApplication::translate("BarreOutils3D", "Affiche/Masque les projections"));
//                layout_w3d->addWidget(projections);

//                espacement1 = new QSpacerItem(10, 10, QSizePolicy::Fixed, QSizePolicy::Fixed);
//                layout_w3d->addItem(espacement1);

//                separateur = new QFrame(parent);
//                separateur->setObjectName("separateur");
//                separateur->setFrameShape(QFrame::VLine);
//                separateur->setFrameShadow(QFrame::Sunken);
//                layout_w3d->addWidget(separateur);

//                espacement2 = new QSpacerItem(10, 10, QSizePolicy::Fixed, QSizePolicy::Fixed);
//                layout_w3d->addItem(espacement2);

//                gen_patron = new QToolButton(parent);
//                gen_patron->setObjectName("gen_patron");
//                QIcon icone_patron;
//                icone_patron.addFile(":/icones/gen_patron.png", QSize(), QIcon::Normal, QIcon::Off);
//                gen_patron->setIcon(icone_patron);
//                gen_patron->setAutoRaise(true);
//                gen_patron->setIconSize(taille_icone);
//                gen_patron->setShortcut(QKeySequence(Qt::CTRL+(Qt::Key_G | Qt::KeypadModifier)));
//                gen_patron->setToolTip(QApplication::translate("BarreOutils3D", "Développement patron"));
//                layout_w3d->addWidget(gen_patron);
            }

            export_fichier = new QToolButton(parent);
            export_fichier->setObjectName("export_fichier");
            QIcon icone_export;
            icone_export.addFile(":/icones/export.png", QSize(), QIcon::Normal, QIcon::Off);
            export_fichier->setIcon(icone_export);
            export_fichier->setAutoRaise(true);
            export_fichier->setIconSize(taille_icone);
            export_fichier->setToolTip(QApplication::translate("BarreOutils3D", "Export 3D"));
            layout_wexport->addWidget(export_fichier);

            export_fichier_2d = new QToolButton(parent);
            export_fichier_2d->setObjectName("export_fichier_2d");
            QIcon icone_export_2d;
            icone_export_2d.addFile(":/icones/plan_virtuel_iso.png", QSize(), QIcon::Normal, QIcon::Off);
            export_fichier_2d->setIcon(icone_export_2d);
            export_fichier_2d->setAutoRaise(true);
            export_fichier_2d->setIconSize(taille_icone);
            export_fichier_2d->setToolTip(QApplication::translate("BarreOutils3D", "Export 2D"));
            layout_wexport->addWidget(export_fichier_2d);

            export_script = new QToolButton(parent);
            export_script->setObjectName("export_script");
            QIcon icone_script;
            icone_script.addFile(":/icones/export_script.png", QSize(), QIcon::Normal, QIcon::Off);
            export_script->setIcon(icone_script);
            export_script->setAutoRaise(true);
            export_script->setIconSize(taille_icone);
            export_script->setToolTip(QApplication::translate("BarreOutils3D", "Enregister le script"));
            layout_wexport->addWidget(export_script);

            export_image_modele = new QToolButton(parent);
            export_image_modele->setObjectName("image_fichier");
            QIcon icone_export_image;
            icone_export_image.addFile(":/icones/export_image.png", QSize(), QIcon::Normal, QIcon::Off);
            export_image_modele->setIcon(icone_export_image);
            export_image_modele->setAutoRaise(true);
            export_image_modele->setIconSize(taille_icone);
            export_image_modele->setToolTip(QApplication::translate("BarreOutils3D", "Enregistrer l'image"));
            layout_wexport->addWidget(export_image_modele);

#ifdef SUPPORT_GIF
            export_animation_modele = new QToolButton(parent);
            export_animation_modele->setObjectName("export_animation");
            QIcon icone_export_animation;
            icone_export_animation.addFile(":/icones/export_animation.png", QSize(), QIcon::Normal, QIcon::Off);
            export_animation_modele->setIcon(icone_export_animation);
            export_animation_modele->setAutoRaise(true);
            export_animation_modele->setIconSize(taille_icone);
            export_animation_modele->setToolTip(QApplication::translate("BarreOutils3D", "Enregistrer animation"));
            layout_wexport->addWidget(export_animation_modele);
#endif // SUPPORT_GIF

            imprime_fichier = new QToolButton(parent);
            imprime_fichier->setObjectName("imprime_fichier");
            QIcon icone_impression;
            icone_impression.addFile(":/icones/imprimer.png", QSize(), QIcon::Normal, QIcon::Off);
            imprime_fichier->setIcon(icone_impression);
            imprime_fichier->setAutoRaise(true);
            imprime_fichier->setIconSize(taille_icone);
            imprime_fichier->setToolTip(QApplication::translate("BarreOutils3D", "Imprimer"));
            layout_wexport->addWidget(imprime_fichier);

            if (!mode_2d)
            {
                proprietes3d = new QToolButton(parent);
                proprietes3d->setObjectName("proprietes3d");
                QIcon icone_props;
                icone_props.addFile(":/icones/proprietes3d.png", QSize(), QIcon::Normal, QIcon::Off);
                proprietes3d->setIcon(icone_props);
                proprietes3d->setAutoRaise(true);
                proprietes3d->setCheckable(true);
                proprietes3d->setIconSize(taille_icone);
                proprietes3d->setShortcut(QKeySequence(Qt::CTRL + Qt::Key_M));
                proprietes3d->setToolTip(QApplication::translate("BarreOutils3D", "Propriétés"));
                layout_wexport->addWidget(proprietes3d);
            }
        }

        ~BarreOutils3D()
        {
            if (vueface) delete vueface;
            if (vuecote) delete vuecote;
            if (vuehaut) delete vuehaut;
            if (vuearriere) delete vuearriere;
            if (vuegauche) delete vuegauche;
            if (vuedessous) delete vuedessous;
            if (vueperspective) delete vueperspective;
            if (projections) delete projections;
            if (gen_patron) delete gen_patron;
            if (export_fichier) delete export_fichier;
            if (export_fichier_2d) delete export_fichier_2d;
            if (export_script) delete export_script;
            if (imprime_fichier) delete imprime_fichier;
            if (export_image_modele) delete export_image_modele;
#ifdef SUPPORT_GIF
            if (export_animation_modele) delete export_animation_modele;
#endif // SUPPORT_GIF
//            if (separateur) delete separateur;
            if (proprietes3d) delete proprietes3d;

            vueface = nullptr;
            vuearriere = nullptr;
            vuecote = nullptr;
            vuegauche = nullptr;
            vuehaut = nullptr;
            vuedessous = nullptr;
            vueperspective = nullptr;
            export_fichier = nullptr;
            export_fichier_2d = nullptr;
            export_script = nullptr;
            imprime_fichier = nullptr;
            export_image_modele = nullptr;
            proprietes3d = nullptr;
#ifdef SUPPORT_GIF
            export_animation_modele = nullptr;
#endif // SUPPORT_GIF
        }

        inline void ChangeEtatOutilsExport(bool etat_general, bool etat_perspective)
        {
            if (export_fichier)
            {
                export_fichier->setEnabled(etat_general);
            }
            if (export_fichier_2d)
            {
                export_fichier_2d->setEnabled(etat_general);
            }
            if (etat_perspective)
            {
                if (export_script)
                {
                    export_script->setEnabled(etat_general);
                }
            }
            if (export_image_modele)
            {
                export_image_modele->setEnabled(etat_general);
            }
            if (imprime_fichier)
            {
                imprime_fichier->setEnabled(etat_general);
            }
        }

//        QSpacerItem *espacement1, *espacement2;
//        QFrame *separateur;

        QToolButton *vueface;
        QToolButton *vuecote;
        QToolButton *vuehaut;

        QToolButton *vuearriere;
        QToolButton *vuegauche;
        QToolButton *vuedessous;

        QToolButton *vueperspective;
        QToolButton *projections;
        QToolButton *gen_patron;
        QToolButton *export_fichier;
        QToolButton *export_fichier_2d;
        QToolButton *export_script;
        QToolButton *imprime_fichier;
        QToolButton *export_image_modele;
        QToolButton *proprietes3d;
#ifdef SUPPORT_GIF
        QToolButton *export_animation_modele;
#endif
};

#endif // BARREOUTILS3D_H
