﻿/**
© Florian Joncour, 2013-2018 florian@zetta-sys.com

Ce logiciel est un programme informatique faisant interface à la bibliothèque
Perspective3D, un outil de modélisation 3D à partir de vues orthographiques 2D.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée.  Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard  l'attention de l'utilisateur est attirée sur les risques
associés au chargement,  à l'utilisation,  à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invités à charger  et  tester  l'adéquation  du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.
**/

/* Objet: Gère le fil d'exécution principal pour les différents modes de Perspective3D */

#ifndef TH_PERSPECTIVE_H
#define TH_PERSPECTIVE_H

#include "perspective_api.h"

#include <QThread>
#include <QMutex>

static QMutex mutex_vision2D;

class Th_ImportDXF : public QThread
{
    public:
        explicit Th_ImportDXF(Perspective3D::PScene2D *s, const QString &fichier, bool ignore_non_imprimables);
        ~Th_ImportDXF();
        void run();

        inline const Perspective3D::PScene2D *Scene() const
        {
            return scene;
        }

        inline Perspective3D::PScene2D *SceneNonConst() const
        {
            return scene;
        }

        inline bool ErreurExec() const
        {
            return (!isFinished() && !isRunning()) && !valide;
        }

        inline bool ValideImport() const
        {
            return valide;
        }

    protected:
        Perspective3D::PScene2D *scene;
        QString fichier_dxf;
        bool valide;
        bool ignore_ents_non_imprimables;
};

#ifdef SUPPORT_VISION2D
class Th_ImportImage : public QThread
{
    public:
        explicit Th_ImportImage(Perspective3D::PScene2D *s, const Perspective3D::ParametresVision &parametres, const QString &fichier);
        ~Th_ImportImage();
        void run();

        inline const Perspective3D::PScene2D *Scene() const
        {
            return scene;
        }

        inline Perspective3D::PScene2D *SceneNonConst() const
        {
            return scene;
        }

        inline const Perspective3D::Vision *Vision2DInst() const { return vision2d; }

        inline bool ErreurExec() const
        {
            return (!isFinished() && !isRunning()) && !valide;
        }

        inline bool ValideImport() const
        {
            return valide;
        }

        inline Perspective3D::resultat_vision2d_t ResultatImport() const
        {
            return resultat_v2d;
        }

    protected:
        Perspective3D::PScene2D *scene;
        Perspective3D::Vision *vision2d;
        const Perspective3D::ParametresVision parametres_conv;
        QString fichier_image;
        bool valide;
        Perspective3D::resultat_vision2d_t resultat_v2d;
};
#endif // SUPPORT_VISION2D

class ExecPerspective
{
    public:
        inline ExecPerspective(pfloat param1=0) : param_gen1(param1) { ; }

        inline pfloat ParamGen1() const { return param_gen1; }

    protected:
        pfloat param_gen1;
};

class Th_ImportSTL3D : public QThread
{
    public:
        explicit Th_ImportSTL3D(Perspective3D::PScene3D *s, const QString &chemin_fichier_stl, puint id_ral=9010, bool fusion_triangles_=false);
        ~Th_ImportSTL3D();
        void run();

        void Stop();

        inline pulong Avancement() const
        {
            return avancement;
        }

        inline const Perspective3D::PScene3D *Scene3D() const
        {
            return scene;
        }

        inline Perspective3D::PScene3D *Scene3DNonConst() const
        {
            return scene;
        }

        bool ValideImport() const;
        bool FinImport() const;

    protected:
        pulong avancement;
        bool interrupteur;
        bool valide_import;
        bool fin_import;
        const QString fichier_stl;
        const puint id_ral_scene;
        bool fusion_triangles;
        Perspective3D::PScene3D *scene;
};

class Th_Perspective : public QThread, public ExecPerspective
{
    public:
        explicit Th_Perspective(Perspective3D::Perspective *p, pfloat param1=0);
        ~Th_Perspective();
        void run();

        inline const Perspective3D::Perspective *Perspective() const
        {
            return perspective;
        }

        inline Perspective3D::Perspective *PerspectiveNonConst() const
        {
            return perspective;
        }

        inline bool ErreurExec() const
        {
            return (!isFinished() && !isRunning());
        }

    protected:
        Perspective3D::Perspective *perspective;
};

class Th_Extrudeur : public Th_Perspective
{
    public:
        Th_Extrudeur(Perspective3D::Perspective *e, pfloat h);
        void run();
};

class Th_Revolution : public Th_Perspective
{
    public:
        Th_Revolution(Perspective3D::Perspective *r, pfloat a);
        void run();
};

class Th_Perspective_n : public Th_Perspective
{
    public:
        explicit Th_Perspective_n(Perspective3D::Perspective *p);
        void run();
//    protected:
//        Perspective3D::Perspective *perspective;
};

#endif // TH_PERSPECTIVE_H
