﻿#ifndef CONFIGVISION_H
#define CONFIGVISION_H

#include "ui_configvision.h"
#include "API/perspective_types.h"

class QSelectCouleur;

class ConfigVision : public QWidget
{
        Q_OBJECT

    public:
        enum DOMAINES_PARAMS_VISION2D { DOMAINE_NUL=0, DOMAINE_IMPORT, DOMAINE_MAIN_LEVEE };

        explicit ConfigVision(QWidget *parent = 0);
        ~ConfigVision();

        bool defParametres(const Perspective3D::ParametresVision &parametres, int domaine_params, int id_page_parametres=0);

        const Perspective3D::ParametresVision &Parametres();
        static const Perspective3D::ParametresVision &ParametresDefauts(int domaine);

        inline int Domaine() const { return Domaine_params; }

        static inline bool ValideDomaine(int domaine) { return domaine > DOMAINE_NUL && domaine <= DOMAINE_MAIN_LEVEE; }
        inline bool ValideDomaine() const { return ConfigVision::ValideDomaine(Domaine()); }

        void ChangePageCourante(int id_page_parametres);
        int PageCourante() const;

    signals:
        void SelectionDomaineParametres(int);

    private slots:
        void NouvelleCouleurTrace(QRgb couleur);
        void on_spb_activation_pixels_valueChanged(int arg1);
        void on_cmb_contour_segments_currentIndexChanged(int index);
        void on_dspb_epsilon_coords_valueChanged(double arg1);
        void on_dspb_approx_coords_valueChanged(double arg1);
        void on_dspb_approx_angles_valueChanged(double arg1);
        void on_dspb_jointure_valueChanged(double arg1);
        void on_dspb_delta_courbure_min_valueChanged(double arg1);
        void on_dspb_delta_courbure_max_valueChanged(double arg1);
        void on_dspb_angle_courbure_min_valueChanged(double arg1);
        void on_dspb_angle_courbure_max_valueChanged(double arg1);
        void on_dspb_jointure_centre_courbes_valueChanged(double arg1);
        void on_cmb_type_config_currentIndexChanged(int index);
        void on_dspb_grille_alignement_valueChanged(double arg1);

    protected:
        void MAJ_SeuilActivation(int v);
        void MAJ_ContourSegments(int v);
        void MAJ_CouleurTrace(const QRgb couleur);
        void MAJ_EpsilonCoords(double v);
        void MAJ_ApproxCoords1(double v);
        void MAJ_ApproxAngles(double v);
        void MAJ_ToleranceJointure(double v);
        void MAJ_DeltaCourbure(double min, double max);
        void MAJ_AngleCourbure(double min, double max);
        void MAJ_JointureCentreCourbes(double v);
        void MAJ_GrilleAlignement(double v);

    private:
        bool init_p;
        Ui::ConfigVision ui;
        QSelectCouleur *w_couleur;
        Perspective3D::ParametresVision Parametres_local;
        int Domaine_params;
};

#endif // CONFIGVISION_H
