varying vec4 color;
varying float intensity;

const float mult_rnd = 15.0;
const float f_min = 0.2;
const float edge_detection = 0.15;

void main(void)
{
    const vec4 v_min = vec4(f_min, f_min, f_min, 0);
    if (intensity > edge_detection)
    {
        float f = floor(intensity * mult_rnd) / mult_rnd;
        gl_FragColor = clamp(color, v_min, vec4(f, f, f, color.w));
    }
    else
    {
        gl_FragColor = vec4(0,0,0,color.w);
    }
}
