﻿/**
© Florian Joncour, 2013-2018 florian@zetta-sys.com

Ce logiciel est un programme informatique faisant interface à la bibliothèque
Perspective3D, un outil de modélisation 3D à partir de vues orthographiques 2D.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée.  Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard  l'attention de l'utilisateur est attirée sur les risques
associés au chargement,  à l'utilisation,  à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invités à charger  et  tester  l'adéquation  du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.
**/

#include <QMainWindow>
#include <QMouseEvent>
#include "BarreOutils2D.h"

BarreOutils2D::BarreOutils2D(int taille_icones_, const char *nom, QMainWindow *parent) : QToolBar(nom, parent), taille_icones(taille_icones_), force_compacte(false)
{
    setAllowedAreas(Qt::LeftToolBarArea | Qt::TopToolBarArea | Qt::RightToolBarArea | Qt::BottomToolBarArea);
    setObjectName(nom);
    setFloatable(true);
    setMovable(true);
    setEnabled(true);
    setIconSize(QSize(taille_icones, taille_icones));
//    setSizePolicy(QSizePolicy::Expanding, QSizePolicy::Expanding);
    setSizePolicy(QSizePolicy::Minimum, QSizePolicy::Minimum);

//    setWindowFlags(Qt::Tool | Qt::FramelessWindowHint | Qt::WindowStaysOnTopHint);

    setWindowFlags(Qt::Tool | Qt::FramelessWindowHint);

    setAttribute(Qt::WA_ShowWithoutActivating);
    setWindowState(Qt::WindowActive);

    Parent = parent;
}

BarreOutils2D::~BarreOutils2D()
{
    ;
}

int BarreOutils2D::Etat()
{
    if (force_compacte)
        return 3;

    const QPoint p = pos();
    int aire = Parent->toolBarArea(this);

    if (p.x() > 30 && p.y() > 30) // Coin supérieur gauche
        return 3; // Carré
    else if (aire == Qt::LeftToolBarArea || aire == Qt::RightToolBarArea)
        return 1; // Barre verticale.
    else if (aire == Qt::TopToolBarArea || aire == Qt::BottomToolBarArea)
        return 2; // Barre horizontale.
    return 3;
}

void BarreOutils2D::GereEtat(int etat)
{
    if (etat < 0)
        etat = Etat();
//    if (!this->isFloating() || !etat)
//        return;

    const unsigned int marge_barre = 5;

    if (etat == 1) // Barre verticale
    {
        setAllowedAreas(Qt::LeftToolBarArea | Qt::TopToolBarArea | Qt::RightToolBarArea | Qt::BottomToolBarArea);
        setOrientation(Qt::Vertical);
        setIconSize(QSize(taille_icones, taille_icones));
        setMaximumSize(QSize(taille_icones*1000, taille_icones*1000));
        setMinimumSize(QSize(taille_icones+marge_barre, taille_icones+marge_barre));

    }
    else if (etat == 2) // Barre horizontale
    {
        setAllowedAreas(Qt::LeftToolBarArea | Qt::TopToolBarArea | Qt::RightToolBarArea | Qt::BottomToolBarArea);
        setOrientation(Qt::Horizontal);
        setIconSize(QSize(taille_icones, taille_icones));
        setMaximumSize(QSize(taille_icones*1000, taille_icones*1000));
        setMinimumSize(QSize(taille_icones+marge_barre, taille_icones+marge_barre));
    }
    else if (etat == 3) // Barre compactée (en carré)
    {
        setAllowedAreas(Qt::NoToolBarArea);
        const int taille = (taille_icones*2);
        const int taille2 = taille+marge_barre;
        setIconSize(QSize(taille2, taille2));
        setMaximumSize(QSize(taille2, taille2));
        setMinimumSize(QSize(taille2, taille2));
    }
}

void BarreOutils2D::defForceCompacte(bool etat)
{
    if (force_compacte == etat)
        return;
    force_compacte = etat;
    if (force_compacte)
    {
//        move(Parent->mapToGlobal(Parent->pos())+QPoint(10, Parent->height()-(height()+10)));
        move(Parent->mapToGlobal(Parent->pos()+QPoint(5, 5)));
        setOrientation(Qt::Horizontal);
    }
    GereEtat(-1);
}

void BarreOutils2D::contextMenuEvent(QContextMenuEvent *ev)
{
    ev->accept(); // Ignore le menu contextuel par défaut de Qt.
}

void BarreOutils2D::mouseDoubleClickEvent(QMouseEvent *ev)
{
    if (isFloating())
        GereEtat(-1);
    ev->accept();
}

void BarreOutils2D::mouseMoveEvent(QMouseEvent *ev)
{
    ev->accept();
}

void BarreOutils2D::moveEvent(QMoveEvent *ev)
{
    int etat = Etat();
    if (etat != 3)
    {
        GereEtat(etat);
    }
    ev->accept();
}
