﻿/**
© Florian Joncour, 2013-2018 florian@zetta-sys.com

Ce logiciel est un programme informatique faisant interface à la bibliothèque
Perspective3D, un outil de modélisation 3D à partir de vues orthographiques 2D.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée.  Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard  l'attention de l'utilisateur est attirée sur les risques
associés au chargement,  à l'utilisation,  à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invités à charger  et  tester  l'adéquation  du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.
**/

#include <QFocusEvent>
#include <QDesktopWidget>
#include "animelogo.h"
#include "Qt/Conversion.h"

#ifdef DEBUG
#include <QDebug>
#endif // DEBUG

#define TAILLE_FENETRE_X 350
#define TAILLE_FENETRE_Y 250

AnimeLogo::AnimeLogo(QWidget *parent) : CadreDialog(parent)
{
//    setWindowFlags(Qt::SplashScreen | Qt::FramelessWindowHint | Qt::WindowStaysOnTopHint); // Foire avec l'affichage plein écran (la fenêtre reste en arrière)...

//#ifdef Q_OS_UNIX
//    setWindowFlags(Qt::FramelessWindowHint | Qt::SplashScreen | Qt::WindowStaysOnTopHint);
//#else
//    setWindowFlags(Qt::Tool | Qt::FramelessWindowHint);
//#endif // Q_OS_UNIX

    ui.setupUi(this);

    setWindowTitle("");
    setWindowIcon(QIcon(GenLogoPerspective3D(false)));
    setWindowModality(Qt::NonModal);

    resize(TAILLE_FENETRE_X, TAILLE_FENETRE_Y);
    setMaximumHeight(TAILLE_FENETRE_X);
    setMaximumHeight(TAILLE_FENETRE_Y);
    setMaximumWidth(TAILLE_FENETRE_X);

    Parent = parent;
    id_timer = -1;
    dernier_id = -1;

    ui.barre_prog->setAlignment(Qt::AlignCenter);
    ui.lbl_txt->setAlignment(Qt::AlignCenter);
    ui.lbl_img->setAlignment(Qt::AlignCenter);

//    ui.lbl_img->setBackgroundRole(QPalette::Dark);
    ui.lbl_img->setAutoFillBackground(true);
}

AnimeLogo::~AnimeLogo()
{
}

bool AnimeLogo::AfficheImage()
/* Affiche l'image suivante (d'après le compteur d'images) */
{
    if (cpt_images <= Perspective3D::NombreLogosAnime() && (dernier_id != cpt_images))
    {
        ui.lbl_img->setPixmap(ConversionPImageQPixmap(Perspective3D::LogoAnime(cpt_images)));
        dernier_id = cpt_images;
        raise(); // On s'assure d'être en haut de la pile d'affichage (en mode plein écran, c'est pas évident sur Windows...)
        return true;
    }
    return false;
}

bool AnimeLogo::AffichePasAPas(int pourcents, const QString &texte)
/* Affiche l'image (en % du nombre d'images) pour l'exécution pas à pas; */
{
    if (pourcents == 100)
    {
        cpt_images = Perspective3D::NombreLogosAnime();
        ui.lbl_txt->setText(texte);
        ui.barre_prog->setVisible(true);
        ui.barre_prog->setValue(100);
        AfficheImage();
        if (id_timer == -1)
        {
            id_timer = startTimer(10);
        }
        return true;
    }
    else
    {
        ui.lbl_txt->setText(texte);
        cpt_images = (int) (((float(Perspective3D::NombreLogosAnime()) * 0.01) * pourcents) + 1.5); // Une image en avance sur le pourcentage réél !
        ui.barre_prog->setVisible(true);
        ui.barre_prog->setValue(pourcents);

        if (AfficheImage())
        {
            return true;
        }
    }
    // On termine, il n'y a plus d'images à afficher:
//    close();
    return false;
}

void AnimeLogo::Anime(const QString &texte)
/* Lance l'animation. */
{
    ui.lbl_txt->setText(texte);
    ui.barre_prog->setVisible(false);
    dernier_id = -1;
    cpt_images = 0;
    show();
    if (id_timer == -1)
    {
        id_timer = startTimer(50); // Délai entre chaque images.
    }
}

void AnimeLogo::showEvent(QShowEvent *ev)
{
    const int marge = 80;
    QScreen *ecran = EcranWidget(Parent);

    if (ecran)
    {
        QRect rect = ecran->geometry();
//        move((rect.width()/2)-(TAILLE_FENETRE_X/2), rect.height()-TAILLE_FENETRE_Y-marge); // Axé X
        move((rect.width())-(TAILLE_FENETRE_X+marge), rect.height()-TAILLE_FENETRE_Y-marge);
    }
    else
    {
        QRect rect = QApplication::desktop()->screenGeometry(QApplication::desktop()->screenNumber(Parent));
//        move((rect.width()/2)-(TAILLE_FENETRE_X/2), rect.height()-TAILLE_FENETRE_Y-marge); // Axé X
        move((rect.width())-(TAILLE_FENETRE_X+marge), rect.height()-TAILLE_FENETRE_Y-marge);
    }

    ev->accept();
}

void AnimeLogo::mousePressEvent(QMouseEvent *ev)
{
    hide();
    ev->accept();
}

void AnimeLogo::moveEvent(QMoveEvent *ev)
{
    ev->ignore();
}

void AnimeLogo::timerEvent(QTimerEvent *ev)
{
    if (cpt_images < Perspective3D::NombreLogosAnime()) // Vidéo en cours.
    {
        AfficheImage();
    }
    else // Fin
    {
        if (cpt_images == Perspective3D::NombreLogosAnime())
        {
            if (id_timer != -1)
            {
                killTimer(id_timer);
            }
            id_timer = startTimer(1000); // Délai avant la fermeture de la fenêtre.
        }
        else
        {
            if (id_timer != -1)
            {
                killTimer(id_timer); // Fin définitive.
                id_timer = -1;
            }
            close();
        }
    }
    ++cpt_images;
    ev->accept();
}
