﻿/**
© Florian Joncour, 2013-2018 florian@zetta-sys.com

Ce logiciel est un programme informatique faisant interface à la bibliothèque
Perspective3D, un outil de modélisation 3D à partir de vues orthographiques 2D.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée.  Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard  l'attention de l'utilisateur est attirée sur les risques
associés au chargement,  à l'utilisation,  à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invités à charger  et  tester  l'adéquation  du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.
**/

/* Objet : Interface pour l'entrée d'une clé d'activation. */

#ifndef DIALOGACTIVATION_H
#define DIALOGACTIVATION_H

#include <QTimer>
#include <QString>
#include "API/perspective_api.h"
#include "perspective_sys.h"
#include "ui_dialogactivation.h"

const int TailleCleActivation = 24; /* Taille de la clé d'activation chiffrée ou non chiffrée mais sans décoration (doit au moins être égal à Perspective3D::LongueurCleActivationChiffre()). */
const int TailleCleActivation_Sep = TailleCleActivation + 3 + 1; /* Taille totale de la clé d'activation non chiffrée (avec les séparateurs et le caractère de terminaison), doit donc valoir au moins Perspective3D::LongueurCleActivationClair().*/

class DialogActivation : public QDialog
{
        Q_OBJECT

    public:
        explicit DialogActivation(puint64 salage_licence, QWidget *parent = 0);
        const pint8 *CleCR() const; /* Renvoi la clé chiffrée. */

        static const QString &StyleContourLicence(const bool activ_2d, const bool activ_3d);

    private slots:
        void timerEvent(QTimerEvent *ev);
        void on_led_cle_textEdited(const QString &arg1);
        void on_buttonBox_clicked(QAbstractButton *button);

    private:
        void GenCleActiv(const QString &txt);
        Ui::DialogActivation ui;
        bool valide;
        pint8 Cle[TailleCleActivation_Sep];
        puint64 SalageLicence;
};

#endif // DIALOGACTIVATION_H
