﻿/**
© Florian Joncour, 2013-2018 florian@zetta-sys.com

Ce logiciel est un programme informatique faisant interface à la bibliothèque
Perspective3D, un outil de modélisation 3D à partir de vues orthographiques 2D.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée.  Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard  l'attention de l'utilisateur est attirée sur les risques
associés au chargement,  à l'utilisation,  à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invités à charger  et  tester  l'adéquation  du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.
**/

/* Objet: Demande à l'utilisateur de sélectionner un fichier. */

#ifndef DIALOGFICHIERS_H
#define DIALOGFICHIERS_H

#include <QString>
#include <QFileDialog>
#include <QPlainTextEdit>

class QLabel;
class ProviderIconesDialog;

enum class TypesFichiers { NUL=0, DOSSIER, DXF_3D, DXF_2D, Z6S, BMP, PNG, JPG, TGA, GIF, STL, x3DS, OBJ, X3D, DAE, PLY, AMF };
TypesFichiers TypeFichier(const QString &s);
/* Renvoi le type de fichier pour le chemin donné en argument */

class QFileDialogP : public QFileDialog
{
        Q_OBJECT
    public:
        explicit QFileDialogP(QWidget* parent = 0, const QString& caption = QString(), const QString& directory = QString(), const QString& filter = QString());
        ~QFileDialogP();

    protected slots:
        void OnCurrentChanged(const QString &chemin);

    protected:
        ProviderIconesDialog *provider_icones_dialog;
        QLabel *entete;
        QLabel *img_apercu;
        QPlainTextEdit *informations;

};

#endif // DIALOGFICHIERS_H
