﻿/**
© Florian Joncour, 2013-2018 florian@zetta-sys.com

Ce logiciel est un programme informatique faisant interface à la bibliothèque
Perspective3D, un outil de modélisation 3D à partir de vues orthographiques 2D.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée.  Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard  l'attention de l'utilisateur est attirée sur les risques
associés au chargement,  à l'utilisation,  à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invités à charger  et  tester  l'adéquation  du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.
**/

/* Objet: Navigateur pour la documentation. */

#ifndef DOCUMENTATION_H
#define DOCUMENTATION_H

#include <QDockWidget>
#include <QTextBrowser>
#include <QString>

#if QT_VERSION >= QT_VERSION_CHECK(5,0,0)
#include <QHelpEngine>
#else
#include <QtHelp/QHelpEngine>
#endif

#include <QPushButton>

class QWidget;
class QVBoxLayout;
class QSplitter;
class QHBoxLayout;
class QLabel;
class QSpacerItem;

class NavigateurDoc : public QTextBrowser
{
        Q_OBJECT
    public:
        NavigateurDoc(QHelpEngine *moteur, const QString &chemin_bin_app, QWidget *parent);
        QVariant loadResource(int type, const QUrl &url);

    signals:
        void ExecFichier(const QString &);
        void OuvreConfig(const QString &);

    private:
        QString chemin_racine_app;
        QHelpEngine *moteurAide;
};

class Documentation : public QDockWidget
{
        Q_OBJECT
    public:
        Documentation(const QString &chemin_zetta6, unsigned int langue, QWidget *parent);
        void OuvrePage(const QString &page, bool force_affichage=true);
        QString PageCourante() const;
        QString CheminDocumentation(const QString &chemin_zetta6) const;
        void Index();
        ~Documentation();

    private slots:
        void sourceChanged(const QUrl &s);
        void PrecedentHistorique();
        void SuivantHistorique();
        void Accueil();
        void ExecFichier_s(const QString &s);
        void OuvreConfig_s(const QString &);
//        void closeEvent(QCloseEvent * ev);

    signals:
        void closeEvent(QCloseEvent *ev);
        void ExecFichier(const QString &);
        void OuvreConfig(const QString &);

    private:
        QWidget *WidgetContenu;
        QVBoxLayout *LayoutContenu;
        QHBoxLayout *LayoutNavigation;
        QPushButton *BoutonPrecedent;
        QPushButton *BoutonSuivant;
        QPushButton *BoutonAccueil;
        QLabel *LabelNavigation;
        QSpacerItem *EspacementNavigation;
        NavigateurDoc *ContenuAide;
        QHelpEngine *Aide;
        QSplitter *Separateur;
        int Langue;
};

class BoutonAide : public QPushButton
{
        Q_OBJECT
    public:
        BoutonAide(Documentation *doc, const char *url, QWidget *parent=0);
        ~BoutonAide();
    private slots:
        void click();
    private:
        QString lien;
        Documentation *documentation;
};

#endif // DOCUMENTATION_H
