﻿#ifndef NOTIFICATIONS_H
#define NOTIFICATIONS_H

#include "ui_wnotifications.h"

enum class IconeNotifications : unsigned int
{
    ICONE_NOTIFICATION_NUL=0,
    ICONE_NOTIFICATION_ATTENTION,
    ICONE_NOTIFICATION_ERREUR,
    ICONE_NOTIFICATION_VALIDE
};

class WNotifications : public QWidget
{
        Q_OBJECT

    public:
        explicit WNotifications(QWidget *parent = 0);

        void AfficheNotification(const QString &texte, IconeNotifications type_icone=IconeNotifications::ICONE_NOTIFICATION_NUL, bool fermeture_auto=false, QWidget *reference_widget=nullptr);
        void MasqueNotification();

        void ChargeStyleNotifications(const QColor &couleur_fond);

    private slots:
        void timerEvent(QTimerEvent *event);
        void on_toolButton_clicked();

    private:
        int id_timer_fermeture;
        Ui::WNotifications ui;
};

#endif // NOTIFICATIONS_H
