﻿/**
© Florian Joncour, 2013-2018 florian@zetta-sys.com

Ce logiciel est un programme informatique faisant interface à la bibliothèque
Perspective3D, un outil de modélisation 3D à partir de vues orthographiques 2D.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée.  Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard  l'attention de l'utilisateur est attirée sur les risques
associés au chargement,  à l'utilisation,  à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invités à charger  et  tester  l'adéquation  du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.
**/

/* Widgets additionnels pour l'interface. */

#include <QWidget>
#include <QToolButton>
#include <QComboBox>
#include <QLineEdit>
#include <QMouseEvent>

class QCompleter;

class QToolButton2 : public QToolButton /* QToolbutton avec émission de signal lors du clic. */
{
        Q_OBJECT
    public:
        inline QToolButton2(QWidget *parent=0) : QToolButton(parent)
        {
        }

        inline ~QToolButton2()
        {
        }

        inline void mousePressEvent(QMouseEvent *ev)
        {
            emit mousePress();
            ev->accept();
        }

    signals:
        void mousePress();
};

class QLineEdit2 : public QLineEdit /* QLineEdit avec émission de signaux lors des entrées/sorties de focus. */
{
        Q_OBJECT
    public:
        inline QLineEdit2(QWidget *parent=0) : QLineEdit(parent)
        {
        }

        inline ~QLineEdit2()
        {
        }

        inline void focusInEvent(QFocusEvent *ev)
        {
            emit focusEvent(true);
            QLineEdit::focusInEvent(ev);
        }

        inline void focusOutEvent(QFocusEvent *ev)
        {
            emit focusEvent(false);
            QLineEdit::focusOutEvent(ev);
        }

    signals:
        void focusEvent(bool);
};

class WExecCommandes : public QComboBox /* Widget d'exécution de commandes avec gestion de l'auto-complétion. */
{
        Q_OBJECT
    public:
        WExecCommandes(QWidget *parent=0);
        ~WExecCommandes();

        void defTexteCommande(const QString &cmd); /* Assigne le texte pour exécuter une commande */
        bool ajoutCompletion(const QString &commande); /* Ajoute une entrée pour l'auto-complétion. */
        void initCompletion(const QStringList &liste, bool insertion_liste=false); /* Initialisation de l'auto-complétion. */
        void keyPressEvent(QKeyEvent *e);

    signals:
        void NouvelleCommande(const QString &);

    protected slots:
        void focusEvent_cmd(bool);

    protected:
        void ExecNouvelleCommande(const QString &txt);
        QCompleter *completer;
        QLineEdit2 *led_cmd;
};
