﻿/**
* @file perspective_div2.h
* @brief Fonctions diverses.
* @author Florian Joncour
* @date 2013-2018
* @copyright Ces sources font partie de l'interface de programmation pour la bibliothèque Perspective3D,
un outils de modélisation 3D à partir de vues orthographiques 2D.
Ces sources sont fournies à titre gracieux, l'utilisateur a la liberté de les exploiter
pour créer des applications dérivées à condition de respecter les conditions suivantes:

    1) Ces sources ne peuvent être modifiées.
    2) Le dérivé ne peut être exploité à des fins commerciaux.
    3) Aucune licence commerciale de la bibliothèque dont est tiré ce fichier ne peut être rendue publique.
    4) Toute application exploitant la présente bibliothèque doit explicitement faire mention de l'usage et du rôle de Perspective3D.

Ces conditions peuvent toutefois être modifiées avec l'accord de l'auteur.
*/

#ifndef PERSPECTIVE_DIV2_H
#define PERSPECTIVE_DIV2_H

#include <vector> /* std::vector */
#include <algorithm> /* std::sort */

/**
 * @brief Comparaison croissante générique (pour qsort()).
 */
template<typename T> inline bool CompareSort(const T &v1, const T &v2)
{
    return (v1<v2);
}

/**
 * @brief Comparaison décroissante générique (pour qsort()).
 */
template<typename T> inline bool CompareSortR(const T &v1, const T &v2)
{
    return (v1>v2);
}

/**
 * @brief Comparaison croissante de nombres entiers (pour qsort()).
 */
inline bool CompareSortInt(const int &v1, const int &v2)
{
    return (v1<v2);
}

/**
 * @brief Comparaison croissante de nombres entiers (pour qsort()).
 */
inline bool CompareSortInt(const long &v1, const long &v2)
{
    return (v1<v2);
}

/**
 * @brief Comparaison décroissante de nombres entiers (pour qsort()).
 */
inline bool CompareSortIntR(const int &v1, const int &v2)
{
    return (v1>v2);
}

/**
 * @brief Comparaison décroissante de nombres entiers (pour qsort()).
 */
inline bool CompareSortIntR(const long &v1, const long &v2)
{
    return (v1>v2);
}

/**
 * @brief TriStdVect Fonction d'interface pour le tri avec qsort() sur un std::vector
 */
template<typename T> inline void TriStdVect(std::vector<T> &vect, bool (*fct_compare)(const T&, const T&))
{
    std::sort(vect.begin(), vect.end(), fct_compare);
}

/**
 * @brief StdVectSupprId Supprime un élément du vecteur d'après son id.
 */
template <class T> inline bool StdVectSupprId(std::vector<T> &v, unsigned int id)
{
#if 1
    if (id < v.size())
    {
        v.erase(v.begin()+id);
        return true;
    }
#else
    const unsigned int n = v.size();
    if (id < n)
    {
        if (n == 1)
        {
            v.clear();
        }
        else
        {
            for(unsigned int i=id+1; i<n; ++i)
            {
                v[i-1] = std::move(v[i]);
            }
            v.pop_back();
        }
        return true;
    }
#endif // 0
    return false;
}

/**
 * @brief StdVectInsert Insert un élément dans un vecteur.
 */
template <class T> inline bool StdVectInsert(std::vector<T> &v, const T &t, unsigned int id)
{
    if (id < v.size())
    {
        v.insert(v.begin()+id, t);
        return true;
    }
    else if (id == v.size())
    {
        v.push_back(t);
        return true;
    }
    return false;
}
#endif // PERSPECTIVE_DIV2_H
