REP_SOURCES = src
REP_ENTETES = src
REP_TR = i18n
REP_UI = ui
REP_RESSOURCES = ressources
REP_LIBS = libs
REP_DOC = doc
CHEMIN_PERSPECTIVE = ../libPerspective3D # Configure le chemin pour trouver la bibliothèque Perspective.

TARGET = Zetta6
TEMPLATE = app

CONFIG += SUPPORT_DOC SUPPORT_I18N SUPPORT_EVAL_EXP SUPPORT_QT

# Ajout du support GIF (permet l'export d'animations).
CONFIG += SUPPORT_GIF

# Support de la diction (voix). Nécessite la bibliothèque ttsPico
CONFIG += SUPPORT_DICTION

# Support de la bibliothèque Vision2D
CONFIG += SUPPORT_VISION

# Support OpenGL dans l'API Perspective3D
CONFIG += SUPPORT_GL

# Support du chargement de bibliothèque dynamique
#CONFIG += SUPPORT_DL

QT += core gui opengl printsupport multimedia network
greaterThan(QT_MAJOR_VERSION, 4): QT += widgets

lessThan(QT_MAJOR_VERSION, 5) {
    CONFIG += help
} else {
    QT += help
}

DESTDIR  = $$OUT_PWD/../../
LIBS += -L$$DESTDIR/ -L$$DESTDIR/lib/

unix:LIBS += -lGLU
win32:LIBS += -lglu32

#CONFIG += link_prl

CONFIG(debug, debug|release) {
    DEFINES  += DEBUG
    QMAKE_CXXFLAGS -= -O2
}

gcc|mingw {
    QMAKE_CXXFLAGS += -std=c++11 -msse2 -mstackrealign

CONFIG(debug, debug|release) {
    DEFINES  += DEBUG
    QMAKE_CXXFLAGS -= -O2
    QMAKE_CXXFLAGS += -Wall -Wextra -Wunreachable-code
}

CONFIG(release, debug|release) {
    QMAKE_CXXFLAGS -= -g -O2
    QMAKE_LFLAGS -= -g

    QMAKE_CXXFLAGS += -O3 -std=c++11 -W -Wall -Wextra -Wno-unused-parameter -Wunreachable-code -Wno-unused-function -Wno-unused-label -Wpointer-arith -Wformat -Wreturn-type -Wsign-compare -Wmultichar -Wformat-nonliteral -Winit-self -Wuninitialized -Wno-deprecated -Wformat-security

    QMAKE_LFLAGS += -O2 -Wl,--no-undefined -s -pedantic
    unix:QMAKE_LFLAGS += -v -static-libgcc -static-libstdc++ -Wl,-z,relro -Wl,-z,now -Wl,--build-id=sha1

#    QMAKE_LFLAGS += -static
} # release
} # gcc|mingw

win32 {
    QMAKE_LFLAGS += -Wl,--subsystem,windows -v -static-libgcc -static-libstdc++
}

#QMAKE_CXXFLAGS += -Woverloaded-virtual

CONFIG(release, debug|release) {
    SUPPORT_DOC {
        include($$REP_DOC/doc.pri)
    }
}

CONFIG(release, debug|release) {
    SUPPORT_I18N {
        include($$REP_TR/i18n.pri)
    }
}

SUPPORT_DL { # Avant le chargement de l'API Perspective3D !
    DEFINES += SUPPORT_DL
    unix:LIBS += -ldl
}

include($$CHEMIN_PERSPECTIVE/API/Perspective_API.pri) # API Perspective3D (nécessite d'avoir défini CHEMIN_PERSPECTIVE).

# Alignement de la version du logiciel sur la bibliothèque Perspective3D
VERSION = $$VERSION_P3D
VER_MAJ = $$VER_MAJ_P3D
VER_MIN = $$VER_MIN_P3D
VER_PAT = $$VER_PAT_P3D

include($$REP_RESSOURCES/ressources.pri)

SUPPORT_DICTION {
    # Support de la diction (TTS), nécessite le liage à la bibliothèque Qt multimédia
    LIBS += -lttspico
    DEFINES += SUPPORT_DICTION
    exists("../libttspico") {
        INCLUDEPATH += ../libttspico/
    }
    include($$REP_LIBS/qDicte/qDicte.pri)
}

SUPPORT_GIF {
    DEFINES += SUPPORT_GIF
    include($$REP_LIBS/jo_gif/jo_gif.pri)
}

SUPPORT_VISION {
    DEFINES += SUPPORT_VISION2D
}

include($$REP_LIBS/qAudioWave/qAudioWave.pri)
include($$REP_LIBS/qSelectCouleur/qSelectCouleur.pri)

SOURCES += $$REP_SOURCES/main.cpp\
    $$REP_SOURCES/mainwindow.cpp \
    $$REP_SOURCES/vue2d.cpp \
    $$REP_SOURCES/vue3d.cpp \
    $$REP_SOURCES/parametres.cpp \
    $$REP_SOURCES/interface3d.cpp \
    $$REP_SOURCES/th_perspective.cpp \
    $$REP_SOURCES/dialogbool.cpp \
    $$REP_SOURCES/dialogint.cpp \
    $$REP_SOURCES/dialogdouble.cpp \
    $$REP_SOURCES/dialogfichiers.cpp \
    $$REP_SOURCES/animelogo.cpp \
    $$REP_SOURCES/documentation.cpp \
    $$REP_SOURCES/proprietes3d.cpp \
    $$REP_SOURCES/interface_texte.cpp \
    $$REP_SOURCES/BarreOutils2D.cpp \
    $$REP_SOURCES/dialogactivation.cpp \
    $$REP_SOURCES/automate.cpp \
    $$REP_SOURCES/animeQt.cpp \
    $$REP_SOURCES/fenetrageZ6.cpp \
    $$REP_SOURCES/dialogqstring.cpp \
    $$REP_SOURCES/gestionnairescripts.cpp \
    $$REP_SOURCES/zwidgets.cpp \
    $$REP_SOURCES/zcalc.cpp \
    $$REP_SOURCES/cl_maj.cpp \
    $$REP_SOURCES/wnotifications.cpp

HEADERS += $$REP_ENTETES/mainwindow.h \
    $$REP_ENTETES/vue2d.h \
    $$REP_ENTETES/vue3d.h \
    $$REP_ENTETES/parametres.h \
    $$REP_ENTETES/BarreOutils3D.h \
    $$REP_ENTETES/style.h \
    $$REP_ENTETES/interface3d.h \
    $$REP_ENTETES/th_perspective.h \
    $$REP_ENTETES/dialogbool.h \
    $$REP_ENTETES/dialogint.h \
    $$REP_ENTETES/dialogdouble.h \
    $$REP_ENTETES/dialogfichiers.h \
    $$REP_ENTETES/version.h \
    $$REP_ENTETES/animelogo.h \
    $$REP_ENTETES/documentation.h \
    $$REP_ENTETES/proprietes3d.h \
    $$REP_ENTETES/BarreOutils2D.h \
    $$REP_ENTETES/interface_texte.h \
    $$REP_ENTETES/dialogactivation.h \
    $$REP_ENTETES/automate.h \
    $$REP_ENTETES/animeQt.h \
    $$REP_SOURCES/fenetrageZ6.h \
    $$REP_ENTETES/dialogqstring.h \
    $$REP_ENTETES/gestionnairescripts.h \
    $$REP_ENTETES/zwidgets.h \
    $$REP_ENTETES/zcalc.h \
    $$REP_ENTETES/cl_maj.h \
    $$REP_ENTETES/wnotifications.h

FORMS += $$REP_UI/mainwindow.ui \
    $$REP_UI/parametres.ui \
    $$REP_UI/dialogbool.ui \
    $$REP_UI/dialogint.ui \
    $$REP_UI/dialogdouble.ui \
    $$REP_UI/animelogo.ui \
    $$REP_UI/interface_texte.ui \
    $$REP_UI/dialogactivation.ui \
    $$REP_UI/dialogqstring.ui \
    $$REP_UI/gestionnairescripts.ui \
    $$REP_UI/wnotifications.ui

SUPPORT_VISION {
    SOURCES += $$REP_SOURCES/configvision.cpp
    HEADERS += $$REP_ENTETES/configvision.h
    FORMS   += $$REP_UI/configvision.ui
}
