varying vec3 normal;
varying vec3 light_pos;

varying vec3 objectColor;

const vec3 coolColor = vec3(0.3, 0.3, 1.0);
const vec3 warmColor = vec3(1.0, 0.3, 0.3);
const float alpha = 0.25;
const float beta = 0.25;

void main(void)
{
   vec3 normalVector = normalize(normal);
   vec3 lightVector = normalize(light_pos);
   float diffuseLighting = dot(lightVector, normalVector); // [-1, 1]
   float interpolationValue = (1.0 + diffuseLighting) * 0.5; // [-1; 1] -> [0, 1]

   vec3 coolColorMod = coolColor + objectColor.xyz * alpha;
   vec3 warmColorMod = warmColor + objectColor.xyz * beta;
   vec3 colorOut = mix(coolColorMod, warmColorMod, interpolationValue);

   gl_FragColor = vec4(colorOut, 1);
}
