uniform sampler2D Texture;
varying vec2 f_texcoord;

const float niveauBlur = 0.001;

void main(void)
{
    vec4 color = texture2D(Texture, f_texcoord) * 2.0;
    
    color += texture2D(Texture, vec2(f_texcoord.s + niveauBlur, f_texcoord.t));
    color += texture2D(Texture, vec2(f_texcoord.s - niveauBlur, f_texcoord.t));
    color += texture2D(Texture, vec2(f_texcoord.s, f_texcoord.t - niveauBlur));
    color += texture2D(Texture, vec2(f_texcoord.s, f_texcoord.t + niveauBlur));
    
    color += texture2D(Texture, vec2(f_texcoord.s + niveauBlur, f_texcoord.t + niveauBlur));
    color += texture2D(Texture, vec2(f_texcoord.s - niveauBlur, f_texcoord.t + niveauBlur));
    color += texture2D(Texture, vec2(f_texcoord.s + niveauBlur, f_texcoord.t - niveauBlur));
    color += texture2D(Texture, vec2(f_texcoord.s - niveauBlur, f_texcoord.t - niveauBlur));
    gl_FragColor = color * 0.1;
}
