﻿/**
© Florian Joncour, 2013-2018 florian@zetta-sys.com

Ce logiciel est un programme informatique faisant interface à la bibliothèque
Perspective3D, un outil de modélisation 3D à partir de vues orthographiques 2D.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée.  Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard  l'attention de l'utilisateur est attirée sur les risques
associés au chargement,  à l'utilisation,  à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invités à charger  et  tester  l'adéquation  du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.
**/

#include "th_perspective.h"

#ifdef DEBUG
#include <QDebug>
#endif

Th_ImportDXF::Th_ImportDXF(Perspective3D::PScene2D *s, const QString &fichier, bool ignore_non_imprimables) :
    scene(s), fichier_dxf(fichier), valide(false), ignore_ents_non_imprimables(ignore_non_imprimables)
{
    ;
}

Th_ImportDXF::~Th_ImportDXF()
{
    ;
}

void Th_ImportDXF::run()
{
    valide = scene->ImportDXF(fichier_dxf.toStdString(), ignore_ents_non_imprimables);
    scene->LiberationImport();
}

#ifdef SUPPORT_VISION2D

Th_ImportImage::Th_ImportImage(Perspective3D::PScene2D *s, const Perspective3D::ParametresVision &parametres, const QString &fichier) :
    scene(s), vision2d(0), parametres_conv(parametres), fichier_image(fichier), valide(false), resultat_v2d(Perspective3D::resultat_vision2d_t::V2D_OK)
{
    ;
}

Th_ImportImage::~Th_ImportImage()
{
    if (vision2d)
    {
        delete vision2d;
    }
}

void Th_ImportImage::run()
{
    if (!mutex_vision2D.tryLock())
    {
        return;
    }

    valide = false;
    Perspective3D::PImage img(fichier_image.toStdString());

    if (img.Valide())
    {
        vision2d = Perspective3D::Vision::Construct(img, parametres_conv, Perspective3D::Ppoint2D(0., 0.), scene);
        resultat_v2d = vision2d->Genere();

        if (resultat_v2d == Perspective3D::resultat_vision2d_t::V2D_OK)
        {
            if (scene->ValideScene())
            {
                valide = true;
            }
        }


//        valide = scene->ImportImage(img, parametres_conv, 0., 0.);
//        scene->LiberationImport();
    }
    else
    {
        valide = false;
    }
    mutex_vision2D.unlock();
}

#endif // SUPPORT_VISION2D

Th_ImportSTL3D::Th_ImportSTL3D(Perspective3D::PScene3D *s, const QString &chemin_fichier_stl, puint id_ral, bool fusion_triangles_) :
    avancement(0), interrupteur(true), valide_import(false), fin_import(false), fichier_stl(chemin_fichier_stl), id_ral_scene(id_ral), fusion_triangles(fusion_triangles_), scene(s)
{
}

Th_ImportSTL3D::~Th_ImportSTL3D()
{
}

void Th_ImportSTL3D::run()
{
    fin_import = false;
    interrupteur = true;
    valide_import = scene->ImportSTL(fichier_stl.toStdString().data(), id_ral_scene, fusion_triangles, &interrupteur, &avancement);
    fin_import = true;
}

void Th_ImportSTL3D::Stop()
{
    interrupteur = false;
}

bool Th_ImportSTL3D::ValideImport() const
{
    return valide_import;
}

bool Th_ImportSTL3D::FinImport() const
{
    return fin_import;
}

Th_Perspective::Th_Perspective(Perspective3D::Perspective *p, pfloat param1): ExecPerspective(param1), perspective(p) /* Mode normal */
{
    ;
}

Th_Perspective::~Th_Perspective()
{
    ;
}

void Th_Perspective::run()
{
    perspective->Generation3D(Perspective3D::modeperspective_t::PMODE_3VUES); /* Genère le modèle 3D */
}

Th_Extrudeur::Th_Extrudeur(Perspective3D::Perspective *e, pfloat h): Th_Perspective(e, h) /* Mode extrusion simple */
{
}

void Th_Extrudeur::run()
{
    perspective->Generation3D(Perspective3D::modeperspective_t::PMODE_EXTRUSION, param_gen1);
}

Th_Revolution::Th_Revolution(Perspective3D::Perspective *r, pfloat a): Th_Perspective(r, a) /* Mode révolution */
{
}

void Th_Revolution::run()
{
    perspective->Generation3D(Perspective3D::modeperspective_t::PMODE_REVOLUTION, param_gen1);
}

Th_Perspective_n::Th_Perspective_n(Perspective3D::Perspective *p): Th_Perspective(p) /* Mode normal sans génération (uniquement pour encapsuler une instance précédente). */
{
    ;
}

void Th_Perspective_n::run()
{
    ;
}
