﻿/**
© Florian Joncour, 2013-2018 florian@zetta-sys.com

Ce logiciel est un programme informatique faisant interface à la bibliothèque
Perspective3D, un outil de modélisation 3D à partir de vues orthographiques 2D.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée.  Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard  l'attention de l'utilisateur est attirée sur les risques
associés au chargement,  à l'utilisation,  à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invités à charger  et  tester  l'adéquation  du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.
**/

#ifndef CONV_QT_H
#define CONV_QT_H

#include "API/perspective_api.h"

#include <QImage>
#include <QPixmap>
#include <QRgb>
#include <QColor>

inline QImage ConversionPImageQImage(const Perspective3D::PImage &image)
/* Conversion PImage->QPixmap */
{
    const unsigned int larg_image = image.Largeur();
    const unsigned int ht_image = image.Hauteur();
    QImage img(larg_image, ht_image, QImage::Format_ARGB32);

    img.fill(Qt::transparent);

    for(unsigned int iy=0; iy<ht_image; ++iy)
    {
        QRgb *d = (QRgb *) img.scanLine(iy);
        for(unsigned int ix=0; ix<larg_image; ++ix)
        {
            const Perspective3D::PPixel &point = image.Pixel(ix, iy);
            d[ix] = qRgba(point.R(), point.V(), point.B(), point.Alpha());
        }
    }

    return img;
}

inline QPixmap ConversionPImageQPixmap(const Perspective3D::PImage &image)
/* Conversion PImage->QPixmap */
{
    const unsigned int larg_image = image.Largeur();
    const unsigned int ht_image = image.Hauteur();
    QImage img(larg_image, ht_image, QImage::Format_ARGB32);

    img.fill(Qt::transparent);

    for(unsigned int iy=0; iy<ht_image; ++iy)
    {
        QRgb *d = (QRgb *) img.scanLine(iy);
        for(unsigned int ix=0; ix<larg_image; ++ix)
        {
            const Perspective3D::PPixel &point = image.Pixel(ix, iy);
            d[ix] = qRgba(point.R(), point.V(), point.B(), point.Alpha());
        }
    }

    QPixmap pix(larg_image, ht_image);
    pix.convertFromImage(img);
    return pix;
}

inline QPixmap GenLogoPerspective3D(bool taille_128=true)
{
    return ConversionPImageQPixmap(Perspective3D::LogoPerspective3D(taille_128));
}

#ifdef SUPPORT_VISION2D
inline QPixmap GenLogoVision2D(bool taille_128=true)
{
    return ConversionPImageQPixmap(Perspective3D::LogoVision2D(taille_128));
}
#endif // SUPPORT_VISION2D

inline QRgb qRgbP(const Perspective3D::PCouleur &c)
{
    return qRgb(c.R(), c.V(), c.B());
}

inline Perspective3D::PCouleur qRgbP(QRgb c)
{
    return Perspective3D::PCouleur(qRed(c), qGreen(c), qBlue(c), qAlpha(c));
}

inline QColor qColor(const Perspective3D::PCouleur &c)
{
    return QColor(qRgbP(c));
}

inline QRgb qRgbP(const Perspective3D::PPixel &c)
{
    return qRgb(c.R(), c.V(), c.B());
}

inline Perspective3D::PPixel qPpixel(QRgb couleur)
{
    return Perspective3D::PPixel(qRed(couleur), qGreen(couleur), qBlue(couleur));
}
#endif // CONV_QT_H
