varying vec4 color;
varying vec3 N;
varying vec3 V;
varying vec3 light_pos;

const float ambient = 0.4;
const float diffuse = 0.5;
const float specular = 0.1;
const float shininess = 60.0;
const float edge_detection = -1.0;

void main (void)
{
    vec3 L = normalize(light_pos - V);
    vec3 R = normalize(-reflect(L,N));

    vec4 amb = color * ambient;

    vec4 diff = color * diffuse * max(dot(N,L), 0.0);
    diff = clamp(diff, 0.0, 1.0);

    vec4 spec = color * specular * pow(max(dot(R, normalize(-V)), 0.0), 0.3 * shininess);
    spec = clamp(spec, 0.0, 1.0);

    float edge = (dot(L, N) > edge_detection) ? 1.0 : 0.0;

    gl_FragColor = vec4(((amb + diff + spec).xyz) * edge, color.w);
}
