uniform mat4 matModel;
uniform mat4 matProjections;
uniform mat4 matNormals;
uniform vec3 LightPos;
attribute vec3 Vertex;
attribute vec3 Normal;

varying vec4 color;
varying vec3 N;
varying vec3 V;
varying vec3 light_pos;

void main(void)
{
    mat4 mvp = matProjections * matModel;
    light_pos = (mvp * vec4(LightPos, 1)).xyz;
    color = gl_Color;
    vec4 vt = mvp * vec4(Vertex, 1);
    V = vt.xyz;
    N = normalize(vec3(matNormals * vec4(Normal, 0)));
    gl_Position = vt;
}
