uniform sampler2D Texture;
uniform vec2 Resolution;
uniform vec3 BackgroundColor;
varying vec2 f_texcoord;

void main(void)
{
    float x = 1.0 / Resolution.x;
    float y = 1.0 / Resolution.y;
    vec4 horizEdge = vec4(BackgroundColor, 1.0);
    horizEdge -= texture2D( Texture, vec2( f_texcoord.x - x, f_texcoord.y - y ) ) * 1.0;
    horizEdge -= texture2D( Texture, vec2( f_texcoord.x - x, f_texcoord.y     ) ) * 2.0;
    horizEdge -= texture2D( Texture, vec2( f_texcoord.x - x, f_texcoord.y + y ) ) * 1.0;
    horizEdge += texture2D( Texture, vec2( f_texcoord.x + x, f_texcoord.y - y ) ) * 1.0;
    horizEdge += texture2D( Texture, vec2( f_texcoord.x + x, f_texcoord.y     ) ) * 2.0;
    horizEdge += texture2D( Texture, vec2( f_texcoord.x + x, f_texcoord.y + y ) ) * 1.0;
    vec4 vertEdge = vec4(BackgroundColor, 1.0);
    vertEdge -= texture2D( Texture, vec2( f_texcoord.x - x, f_texcoord.y - y ) ) * 1.0;
    vertEdge -= texture2D( Texture, vec2( f_texcoord.x    , f_texcoord.y - y ) ) * 2.0;
    vertEdge -= texture2D( Texture, vec2( f_texcoord.x + x, f_texcoord.y - y ) ) * 1.0;
    vertEdge += texture2D( Texture, vec2( f_texcoord.x - x, f_texcoord.y + y ) ) * 1.0;
    vertEdge += texture2D( Texture, vec2( f_texcoord.x    , f_texcoord.y + y ) ) * 2.0;
    vertEdge += texture2D( Texture, vec2( f_texcoord.x + x, f_texcoord.y + y ) ) * 1.0;
    vec3 edge = sqrt((horizEdge.rgb * horizEdge.rgb) + (vertEdge.rgb * vertEdge.rgb));
    
    gl_FragColor = vec4(edge, texture2D(Texture, f_texcoord).a);
}
