﻿#include "configvision.h"
#include "qSelectCouleur.h"

#include <cmath>
#include "Conversion.h"
#include <QPainter>
#include <QImage>
#include <QPixmap>
#include <QVariant>
#include <QGradient>
#include <QVector2D>

#ifdef DEBUG
#include <QDebug>
#endif

//#define TAILLE_MINIATURES_X 96
//#define TAILLE_MINIATURES_Y 96
#define TAILLE_MINIATURES_X 88
#define TAILLE_MINIATURES_Y 88

#define TAILLE_MINIATURES_X_LARGE 200

const QColor couleur_transparent(Qt::transparent);
//const QColor couleur_noir(Qt::black);
//const QColor couleur_blanc(Qt::white);
//const QColor couleur_rouge(Qt::red);
//const QColor couleur_vert(Qt::green);
//const QColor couleur_bleu(Qt::blue);

const QColor couleur_noir(qRgb(10, 10, 10));
const QColor couleur_blanc(qRgb(210, 210, 210));
const QColor couleur_rouge(qRgb(230, 60, 60));
const QColor couleur_vert(qRgb(75, 220, 75));
const QColor couleur_bleu(qRgb(75, 75, 220));

/* Paramétrage par défaut pour l'import d'image: */
static const struct Perspective3D::ParametresVision Parametres_defaut_import =
{
        210,   /* SeuilActivation */
        false, /* ContourSegments */
        Perspective3D::PPixel(0xff4ed94b), /* CouleurTrace */
        pfloat(0.95),  /* EpsilonCoords */
        pfloat(1.70),  /* ToleranceCoords1 */
        pfloat(2.00),  /* ToleranceCoords2 */
        pfloat(6.00),  /* ToleranceAngles */
        pfloat(7.00),  /* ToleranceJointures */
        pfloat(6.50),  /* ToleranceCourbure */
        pfloat(0.95),  /* ToleranceJointuresCentreCourbes */
        pfloat(0.50),  /* DeltaCourbesMin */
        pfloat(15.0),  /* DeltaCourbesMax */
        pfloat(0.1),   /* ToleranceNorms */
        pfloat(120.0), /* DeltaAnglesCourbesMin */
        pfloat(179.0), /* DeltaAnglesCourbesMax */
        pfloat(3.0),   /* TailleGrille */
        nullptr,       /* Licence */
        0              /* Valeur de salage de la licence */
};

/* Paramétrage par défaut pour le dessin à main levée */
static const struct Perspective3D::ParametresVision Parametres_defaut_tracage =
{
        210,   /* SeuilActivation */
        false, /* ContourSegments */
        Perspective3D::PPixel(0xffa8a8a8), /* CouleurTrace */
        pfloat(0.95),  /* EpsilonCoords */
        pfloat(5),     /* ToleranceCoords1 */
        pfloat(6),     /* ToleranceCoords2 */
        pfloat(10.0),  /* ToleranceAngles */
        pfloat(10.0),  /* ToleranceJointures */
        pfloat(8.50),  /* ToleranceCourbure */
        pfloat(0.95),  /* ToleranceJointuresCentreCourbes */
        pfloat(3.50),  /* DeltaCourbesMin */
        pfloat(15.0),  /* DeltaCourbesMax */
        pfloat(0.15),  /* ToleranceNorms */
        pfloat(120.0), /* DeltaAnglesCourbesMin */
        pfloat(179.0), /* DeltaAnglesCourbesMax */
        pfloat(12.0),  /* TailleGrille */
        nullptr,       /* Licence */
        0              /* Valeur de salage de la licence */
};


inline QVector2D CalcVectAngle(double angle)
{
    angle *= DTOR;
    return QVector2D(cos(angle), sin(angle));
}

QPixmap GenImg2Points(QWidget *parent, double distance)
{
    Q_UNUSED(parent);
    const double echelle = 8.;
    QPixmap img(TAILLE_MINIATURES_X, TAILLE_MINIATURES_Y);
    img.fill(QColor(0,0,0,0));
    QPainter paint(&img);
//    paint.setBrush(couleur_noir);

    paint.setPen(couleur_noir);
    QFont font = paint.font();
    font.setWeight(10);
    font.setBold(true);
    paint.setFont(font);

    const int separation = 6;
    const double centre_x = double(TAILLE_MINIATURES_X) * 0.5;
    const double centre_y = (double(TAILLE_MINIATURES_Y) * 0.5)-separation;

    paint.drawText(QPoint(2, int(centre_y+0.5)+(separation+12)), QObject::tr("Echelle : %1x").arg(QVariant(echelle).toString()));

    const QRectF rect_cercle1(centre_x-((distance*echelle)*0.5)-echelle, centre_y-echelle, echelle, echelle);
    const QRectF rect_cercle2(centre_x+((distance*echelle)*0.5)-echelle, centre_y-echelle, echelle, echelle);

    paint.setPen(couleur_transparent);

    QRadialGradient radialGrad1(rect_cercle1.center(), echelle);
    radialGrad1.setColorAt(0, couleur_transparent);
    radialGrad1.setColorAt(1.0, couleur_noir);

    QBrush brush1(radialGrad1);
    paint.setBrush(brush1);
    paint.drawEllipse(rect_cercle1);

    QRadialGradient radialGrad2(rect_cercle2.center(), echelle);
    radialGrad2.setColorAt(0, couleur_transparent);
    radialGrad2.setColorAt(1.0, couleur_noir);
    QBrush brush2(radialGrad2);
    paint.setBrush(brush2);
    paint.drawEllipse(rect_cercle2);

    return img;
}

QPixmap GenImgGrille(QWidget *parent, double distance)
{
    Q_UNUSED(parent);
    const double echelle = 1.0;
    QPixmap img(TAILLE_MINIATURES_X, TAILLE_MINIATURES_Y);
    img.fill(QColor(0,0,0,0));

    QPainter paint(&img);
    QFont font = paint.font();
    font.setWeight(10);
    font.setBold(true);
    paint.setFont(font);

    distance *= echelle;

    if (distance < (TAILLE_MINIATURES_X/2)) // Affichage patron de grille...
    {
        QColor couleur_trace = couleur_noir;
        couleur_trace.setAlpha(80);
        paint.setPen(couleur_trace);

        const double centre_x = double(TAILLE_MINIATURES_X) * 0.5;
        const double centre_y = (double(TAILLE_MINIATURES_Y) * 0.5);

        double dx = 0.5;
        double dy = 0.5;

        while (dx < TAILLE_MINIATURES_X)
        {
            paint.drawLine(QPointF((centre_x-dx), 0), QPointF((centre_x-dx), TAILLE_MINIATURES_X-1));
            paint.drawLine(QPointF((centre_x+dx), 0), QPointF((centre_x+dx), TAILLE_MINIATURES_X-1));
            dx += distance;
        }

        while (dy < TAILLE_MINIATURES_Y)
        {
            paint.drawLine(QPointF(0, (centre_y-dy)), QPointF(TAILLE_MINIATURES_Y-1, (centre_y-dy)));
            paint.drawLine(QPointF(0, (centre_y+dy)), QPointF(TAILLE_MINIATURES_Y-1, (centre_y+dy)));
            dy += distance;
        }
    }
    else // Affichage d'un simple caré central...
    {
        paint.setPen(couleur_noir);

        const int separation = 0;
        const double centre_x = double(TAILLE_MINIATURES_X) * 0.5;
        const double centre_y = (double(TAILLE_MINIATURES_Y) * 0.5) - separation;
        const double demi_distance = (distance * 0.5);

        //    paint.drawText(QPoint(2, (TAILLE_MINIATURES_Y)-(separation+12)), QObject::tr("Echelle : %1x").arg(QVariant(echelle).toString()));

        paint.drawLine(QPointF(centre_x-demi_distance, 0), QPointF(centre_x-demi_distance, TAILLE_MINIATURES_X-separation-1));
        paint.drawLine(QPointF(centre_x+demi_distance, 0), QPointF(centre_x+demi_distance, TAILLE_MINIATURES_X-separation-1));

        paint.drawLine(QPointF(0, centre_y-demi_distance), QPointF(TAILLE_MINIATURES_Y-separation-1, centre_y-demi_distance));
        paint.drawLine(QPointF(0, centre_y+demi_distance), QPointF(TAILLE_MINIATURES_Y-separation-1, centre_y+demi_distance));
    }
    return img;
}

ConfigVision::ConfigVision(QWidget *parent) : QWidget(parent), init_p(false), Domaine_params(DOMAINE_MAIN_LEVEE)
{
    ui.setupUi(this);
    ui.logo_vision->setPixmap(GenLogoVision2D(false));
    w_couleur = new QSelectCouleur(true); /* Mode miniature */
//    w_couleur = new QSelectCouleur(ui.page_couleur);
    ui.page_couleur->layout()->addWidget(w_couleur);

    connect(w_couleur, SIGNAL(NouvelleCouleur(QRgb)), this, SLOT(NouvelleCouleurTrace(QRgb)));

    init_p = true;
    ChangePageCourante(0);
}

ConfigVision::~ConfigVision()
{
    delete w_couleur;
}

bool ConfigVision::defParametres(const Perspective3D::ParametresVision &parametres, int domaine_params, int id_page_parametres)
/* Assignation de nouveaux paramètres, mis à jour de l'interface en conséquence. */
{
    if (init_p && ui.cmb_type_config->currentIndex() != (domaine_params-1))
    {
        if (ValideDomaine(domaine_params))
        {
            ui.cmb_type_config->setCurrentIndex(domaine_params-1);
        }
    }

    Domaine_params = domaine_params;
    Parametres_local = parametres;

//    if (Domaine_params == DOMAINE_MAIN_LEVEE)
//    {
//        if (ui.toolBox->currentIndex() == 0)
//        {
//            ui.toolBox->setCurrentIndex(1);
//        }
//        ui.cmb_contour_segments->setEnabled(false);
//        ui.spb_activation_pixels->setEnabled(false);
//    }
//    else
//    {
//        ui.cmb_contour_segments->setEnabled(true);
//        ui.spb_activation_pixels->setEnabled(true);
//    }

    if (id_page_parametres == -1) /* Réinitialisation générale. */
    {
        /* Mise à jour de l'interface. */
        MAJ_SeuilActivation(parametres.SeuilActivation);
        MAJ_ContourSegments(int(parametres.ContourSegments));
        MAJ_CouleurTrace(qRgbP(parametres.CouleurTrace));
        MAJ_EpsilonCoords(parametres.EpsilonCoords);
        MAJ_ApproxCoords1(parametres.ToleranceCoords1);
        MAJ_ApproxAngles(parametres.ToleranceAngles);
        MAJ_ToleranceJointure(parametres.ToleranceJointures);
        MAJ_DeltaCourbure(parametres.DeltaCourbesMin, parametres.DeltaCourbesMax);
        MAJ_AngleCourbure(parametres.DeltaAnglesCourbesMin, parametres.DeltaAnglesCourbesMax);
        MAJ_JointureCentreCourbes(parametres.ToleranceJointuresCentreCourbes);
        MAJ_GrilleAlignement(parametres.TailleGrille);
    }
    else if (id_page_parametres == 0)
    {
        MAJ_SeuilActivation(parametres.SeuilActivation);
        MAJ_ContourSegments(int(parametres.ContourSegments));
        MAJ_GrilleAlignement(parametres.TailleGrille);
    }
    else if (id_page_parametres == 1)
    {
        MAJ_EpsilonCoords(parametres.EpsilonCoords);
        MAJ_ApproxCoords1(parametres.ToleranceCoords1);
    }
    else if (id_page_parametres == 2)
    {
        MAJ_ApproxAngles(parametres.ToleranceAngles);
        MAJ_ToleranceJointure(parametres.ToleranceJointures);
    }
    else if (id_page_parametres == 3)
    {
        MAJ_DeltaCourbure(parametres.DeltaCourbesMin, parametres.DeltaCourbesMax);
        MAJ_AngleCourbure(parametres.DeltaAnglesCourbesMin, parametres.DeltaAnglesCourbesMax);
        MAJ_JointureCentreCourbes(parametres.ToleranceJointuresCentreCourbes);
    }
    else if (id_page_parametres == 4)
    {
        MAJ_CouleurTrace(qRgbP(parametres.CouleurTrace));
    }
    else /* Erreur d'id ?! */
    {
        return false;
    }
    return true;
}

void ConfigVision::ChangePageCourante(int id_page_parametres)
{
    ui.toolBox->setCurrentIndex(id_page_parametres);
}

int ConfigVision::PageCourante() const
{
    return ui.toolBox->currentIndex();
}

const Perspective3D::ParametresVision &ConfigVision::Parametres()
{
    return Parametres_local;
}

const Perspective3D::ParametresVision &ConfigVision::ParametresDefauts(int domaine)
{
    if (domaine == DOMAINE_MAIN_LEVEE)
    {
        return Parametres_defaut_tracage;
    }
    return Parametres_defaut_import;
}

void ConfigVision::MAJ_SeuilActivation(int v)
{
    if (ui.spb_activation_pixels->value() != v)
    {
        ui.spb_activation_pixels->setValue(v);
    }
    else
    {
//        return;
    }

    ui.lbl_activation_pixel->clear();
    QImage img(TAILLE_MINIATURES_X, TAILLE_MINIATURES_Y, QImage::Format_Grayscale8);
    img.fill(255-v);
    ui.lbl_activation_pixel->setPixmap(QPixmap::fromImage(img));
}

void ConfigVision::MAJ_ContourSegments(int v)
{
    if (ui.cmb_contour_segments->currentIndex() != v)
    {
        ui.cmb_contour_segments->setCurrentIndex(v);
    }
    else
    {
//        return;
    }

    ui.lbl_type_contour_segments->clear();
    if (v == 0)
    {
        ui.lbl_type_contour_segments->setPixmap(QPixmap(":/icones/conf_vision/reduction_int.png").scaled(TAILLE_MINIATURES_X, TAILLE_MINIATURES_Y, Qt::KeepAspectRatio, Qt::SmoothTransformation));
    }
    else if (v == 1)
    {
        ui.lbl_type_contour_segments->setPixmap(QPixmap(":/icones/conf_vision/reduction_ext.png").scaled(TAILLE_MINIATURES_X, TAILLE_MINIATURES_Y, Qt::KeepAspectRatio, Qt::SmoothTransformation));
    }
    else
    {
        return;
    }
}

void ConfigVision::MAJ_GrilleAlignement(double v)
{
    if (!CompareE(v, ui.dspb_grille_alignement->value()))
    {
        ui.dspb_grille_alignement->setValue(v);
    }
    else
    {
//        return;
    }

    ui.lbl_grille_alignement->clear();

    if (CompareE(v, 0))
    {
        return;
    }

    ui.lbl_grille_alignement->setPixmap(GenImgGrille(this, v));
}

void ConfigVision::MAJ_CouleurTrace(const QRgb couleur)
{
    if (w_couleur)
    {
        w_couleur->defCouleur(couleur);
    }
}

void ConfigVision::MAJ_EpsilonCoords(double v)
{
    if (!CompareE(v, ui.dspb_epsilon_coords->value()))
    {
        ui.dspb_epsilon_coords->setValue(v);
    }
    else
    {
//        return;
    }

    ui.lbl_epsilon_coords->clear();
    ui.lbl_epsilon_coords->setPixmap(GenImg2Points(this, v));
}

void ConfigVision::MAJ_ApproxCoords1(double v)
{
    if (!CompareE(v, ui.dspb_approx_coords->value()))
    {
        ui.dspb_approx_coords->setValue(v);
    }
    else
    {
//        return;
    }

    ui.lbl_approx_coords->clear();
    ui.lbl_approx_coords->setPixmap(GenImg2Points(this, v));
}

void ConfigVision::MAJ_ApproxAngles(double v)
{
    if (!CompareE(v, ui.dspb_approx_angles->value()))
    {
        ui.dspb_approx_angles->setValue(v);
    }
    else
    {
//        return;
    }

    ui.lbl_approx_angles->clear();

    QPixmap img(TAILLE_MINIATURES_X_LARGE, TAILLE_MINIATURES_Y);
    img.fill(QColor(0,0,0,0));

    const double lg_x = double(TAILLE_MINIATURES_X_LARGE) * 0.5;
    const double lg_y = double(TAILLE_MINIATURES_Y) * 0.5;

    QVector2D vect = CalcVectAngle(v);
    QPointF p1 = (vect * lg_x).toPointF();
    QPointF centre(lg_x, lg_y);
    QPointF p2(lg_x, 0);

    QPainter paint(&img);
    QPen pen = paint.pen();
    pen.setWidth(1);
    pen.setStyle(Qt::DashDotLine);
    pen.setColor(couleur_rouge);
    paint.setPen(pen);
    paint.drawLine(centre-p2, centre+p2);

    pen.setWidth(2);
    pen.setStyle(Qt::SolidLine);
    pen.setColor(couleur_noir);
    paint.setPen(pen);
    paint.drawLine(centre-p1, centre+p1);

    ui.lbl_approx_angles->setPixmap(img);
}

void ConfigVision::MAJ_ToleranceJointure(double v)
{
    if (!CompareE(v, ui.dspb_jointure->value()))
    {
        ui.dspb_jointure->setValue(v);
    }
    else
    {
//        return;
    }

    ui.lbl_jointure->clear();

    QPixmap img(TAILLE_MINIATURES_X_LARGE, TAILLE_MINIATURES_Y);
    img.fill(QColor(0,0,0,0));

    const double lg_x = double(TAILLE_MINIATURES_X_LARGE) * 0.5;
    const double lg_y = double(TAILLE_MINIATURES_Y) * 0.5;

    QPointF p1(0, v*0.5);
    QPointF centre(lg_x, lg_y);
    QPointF p2(lg_x, 0);

    QPainter paint(&img);
    QPen pen = paint.pen();
    pen.setWidth(1);
    pen.setStyle(Qt::DashDotLine);
    pen.setColor(couleur_rouge);
    paint.setPen(pen);
    paint.drawLine(centre-p2, centre+p2);

    pen.setWidth(1);
    pen.setStyle(Qt::SolidLine);
    pen.setColor(couleur_noir);
    paint.setPen(pen);
    paint.drawLine(QPointF(1.0, lg_y), centre-p1);
    paint.drawLine(QPointF(TAILLE_MINIATURES_X_LARGE-1.0, lg_y), centre+p1);
    ui.lbl_jointure->setPixmap(img);
}

void ConfigVision::MAJ_DeltaCourbure(double min, double max)
{
    bool maj = false;
    if (!CompareE(min, ui.dspb_delta_courbure_min->value()))
    {
        ui.dspb_delta_courbure_min->setValue(min);
        maj = true;
    }
    if (!CompareE(max, ui.dspb_delta_courbure_max->value()))
    {
        ui.dspb_delta_courbure_max->setValue(max);
        maj = true;
    }

    if (!maj)
    {
//        return;
    }

    ui.lbl_delta_courbure->clear();

    QPixmap img(TAILLE_MINIATURES_X, TAILLE_MINIATURES_Y);
    img.fill(QColor(0,0,0,0));

//    const double centre_x = double(TAILLE_MINIATURES_X) * 0.5;
    const double centre_y = double(TAILLE_MINIATURES_Y) * 0.5;

    QPainter paint(&img);
    QPen pen = paint.pen();

    pen.setWidth(1);
    pen.setStyle(Qt::SolidLine);
    pen.setColor(couleur_rouge);
    paint.setPen(pen);
    paint.drawArc(QRectF(0, (centre_y*0.25), TAILLE_MINIATURES_X, min*4.0), 30*16, 120*16);

    pen.setWidth(1);
    pen.setStyle(Qt::DashDotLine);
    pen.setColor(couleur_bleu);
    paint.setPen(pen);
    paint.drawPie(QRectF(0, (centre_y*0.25), TAILLE_MINIATURES_X, ((min+max)*0.5)*4.0), 30*16, 120*16);

    pen.setStyle(Qt::SolidLine);
    pen.setColor(couleur_vert);
    paint.setPen(pen);
    paint.drawArc(QRectF(0, (centre_y*0.25), TAILLE_MINIATURES_X, max*4.0), 30*16, 120*16);

    ui.lbl_delta_courbure->setPixmap(img);
}

void ConfigVision::MAJ_AngleCourbure(double min, double max)
{
    bool maj = false;
    if (!CompareE(min, ui.dspb_angle_courbure_min->value()))
    {
        ui.dspb_angle_courbure_min->setValue(min);
        maj = true;
    }
    if (!CompareE(max, ui.dspb_angle_courbure_max->value()))
    {
        ui.dspb_angle_courbure_max->setValue(max);
        maj = true;
    }

    if (!maj)
    {
//        return;
    }

    ui.lbl_delta_angle_courbure->clear();

    QPixmap img(TAILLE_MINIATURES_X, TAILLE_MINIATURES_Y);
    img.fill(QColor(0,0,0,0));

    QVector2D v_min = CalcVectAngle((min*-0.5) + 90.);
    QVector2D v_max = CalcVectAngle((max*-0.5) + 90.);
    QVector2D v_min2 = CalcVectAngle((min*0.5) + 90.);
    QVector2D v_max2 = CalcVectAngle((max*0.5) + 90.);

    const double lg_x = double(TAILLE_MINIATURES_X) * 0.5;
    const double lg_y = double(TAILLE_MINIATURES_Y) * 0.5;

    QPointF origine(lg_x, lg_y*0.25);
    QPointF p_min = (v_min * lg_x).toPointF();
    QPointF p_max = (v_max * lg_x).toPointF();
    QPointF p_min2 = (v_min2 * lg_x).toPointF();
    QPointF p_max2 = (v_max2 * lg_x).toPointF();

    QPainter paint(&img);
    QPen pen = paint.pen();

    QBrush brush_orig = pen.brush();
    QRadialGradient gradient(origine, lg_x);
    gradient.setColorAt(0, couleur_bleu);
    gradient.setColorAt(1, couleur_transparent);

    QBrush brush_temp(gradient);

    pen.setColor(couleur_transparent);
    paint.setPen(pen);
    paint.setBrush(brush_temp);
    const QPointF poly_min[3] = { origine+p_min, origine, origine+p_max };
    const QPointF poly_max[3] = { origine+p_min2, origine, origine+p_max2 };
    paint.drawPolygon(poly_min, 3);
    paint.drawPolygon(poly_max, 3);

    paint.setBrush(brush_orig);

    pen.setWidth(1);
    pen.setStyle(Qt::SolidLine);
    pen.setColor(couleur_rouge);
    paint.setPen(pen);
    paint.drawLine(origine, origine+p_min);
    paint.drawLine(origine, origine+p_min2);

    pen.setWidth(1);
    pen.setStyle(Qt::SolidLine);
    pen.setColor(couleur_vert);
    paint.setPen(pen);
    paint.drawLine(origine, origine+p_max);
    paint.drawLine(origine, origine+p_max2);

    ui.lbl_delta_angle_courbure->setPixmap(img);
}

void ConfigVision::MAJ_JointureCentreCourbes(double v)
{
    const double v_pct = v*100.;
    if (!CompareE(v_pct, ui.dspb_jointure_centre_courbes->value()))
    {
        ui.dspb_jointure_centre_courbes->setValue(v_pct);
    }
    else
    {
//        return;
    }

    ui.lbl_jointure_centre_courbes->clear();

    QPixmap img(TAILLE_MINIATURES_X, TAILLE_MINIATURES_Y);
    img.fill(QColor(0,0,0,0));

    const double marge = 3.0; // 3.0
    const double taille_points = 7.0;
    const double diametre_cercle = double(qMin(TAILLE_MINIATURES_X, TAILLE_MINIATURES_Y))-(marge+marge);
    const double rayon_cercle = (diametre_cercle)*0.5;
    const double centre_x = double(TAILLE_MINIATURES_X) * 0.5;
    const double centre_y = double(TAILLE_MINIATURES_Y) * 0.5;
    const double taille_axe_centre = rayon_cercle*0.25;

    const double delta_cercles = ((rayon_cercle*0.5) * (v));

    QPainter paint(&img);
    QPen pen = paint.pen();

    pen.setWidth(1);
    pen.setColor(couleur_rouge);
    pen.setStyle(Qt::DashDotLine);
    paint.setPen(pen);
    paint.drawLine(QPointF(centre_x, centre_y-taille_axe_centre), QPointF(centre_x, centre_y+taille_axe_centre));
    paint.drawLine(QPointF(centre_x-delta_cercles, centre_y), QPointF(centre_x+delta_cercles, centre_y));

    pen.setWidth(2);
    pen.setStyle(Qt::SolidLine);
    pen.setColor(couleur_blanc);
    paint.setPen(pen);
    paint.drawEllipse((centre_x-rayon_cercle), (centre_y-rayon_cercle), diametre_cercle, diametre_cercle);

    pen.setWidth(1);
    pen.setStyle(Qt::SolidLine);
    pen.setColor(couleur_transparent);
    paint.setPen(pen);
    QRectF rect_point1(centre_x-delta_cercles-(taille_points*0.5), centre_y-(taille_points*0.5), taille_points, taille_points);
    QRectF rect_point2(centre_x+delta_cercles-(taille_points*0.5), centre_y-(taille_points*0.5), taille_points, taille_points);

    QRadialGradient radialGrad1(rect_point1.center(), taille_points*0.5);
    radialGrad1.setColorAt(0, couleur_vert);
    radialGrad1.setColorAt(1.0, couleur_transparent);
    QBrush brush_points1(radialGrad1);
    paint.setBrush(brush_points1);
    paint.drawEllipse(rect_point1);

    QRadialGradient radialGrad2(rect_point2.center(), taille_points*0.5);
    radialGrad2.setColorAt(0, couleur_vert);
    radialGrad2.setColorAt(1.0, couleur_transparent);
    QBrush brush_points2(radialGrad2);
    paint.setBrush(brush_points2);
    paint.drawEllipse(rect_point2);

    ui.lbl_jointure_centre_courbes->setPixmap(img);
}

void ConfigVision::NouvelleCouleurTrace(QRgb couleur)
{
    Parametres_local.CouleurTrace = qPpixel(couleur);
    MAJ_CouleurTrace(couleur);
}

void ConfigVision::on_spb_activation_pixels_valueChanged(int arg1)
{
    Parametres_local.SeuilActivation = arg1;
    MAJ_SeuilActivation(arg1);
}

void ConfigVision::on_cmb_contour_segments_currentIndexChanged(int index)
{
    Parametres_local.ContourSegments = bool(index);
    MAJ_ContourSegments(index);
}

void ConfigVision::on_dspb_epsilon_coords_valueChanged(double arg1)
{
    Parametres_local.EpsilonCoords = arg1;
    MAJ_EpsilonCoords(arg1);
}

void ConfigVision::on_dspb_approx_coords_valueChanged(double arg1)
{
    Parametres_local.ToleranceCoords1 = arg1;
    Parametres_local.ToleranceCoords2 = arg1 * 1.20;
    MAJ_ApproxCoords1(arg1);
}

void ConfigVision::on_dspb_approx_angles_valueChanged(double arg1)
{
    Parametres_local.ToleranceAngles = arg1;
    Parametres_local.ToleranceNorms = PI / (30.0 - arg1);
//    Parametres_local.ToleranceNorms = (PI / (40.0 - arg1));
    MAJ_ApproxAngles(arg1);
}

void ConfigVision::on_dspb_jointure_valueChanged(double arg1)
{
    Parametres_local.ToleranceJointures = arg1;
//    Parametres_local.ToleranceCourbure = arg1 * 1.85;
    Parametres_local.ToleranceCourbure = arg1 * 0.85;
    MAJ_ToleranceJointure(arg1);
}

void ConfigVision::on_dspb_delta_courbure_min_valueChanged(double arg1)
{
    Parametres_local.DeltaCourbesMin = arg1;
    MAJ_DeltaCourbure(arg1, ui.dspb_delta_courbure_max->value());
}

void ConfigVision::on_dspb_delta_courbure_max_valueChanged(double arg1)
{
    Parametres_local.DeltaCourbesMax = arg1;
    MAJ_DeltaCourbure(ui.dspb_delta_courbure_min->value(), arg1);
}

void ConfigVision::on_dspb_angle_courbure_min_valueChanged(double arg1)
{
    Parametres_local.DeltaAnglesCourbesMin = arg1;
    MAJ_AngleCourbure(arg1, ui.dspb_angle_courbure_max->value());
}

void ConfigVision::on_dspb_angle_courbure_max_valueChanged(double arg1)
{
    Parametres_local.DeltaAnglesCourbesMax = arg1;
    MAJ_AngleCourbure(ui.dspb_angle_courbure_min->value(), arg1);
}

void ConfigVision::on_dspb_jointure_centre_courbes_valueChanged(double arg1)
{
    Parametres_local.ToleranceJointuresCentreCourbes = arg1*0.01;
    MAJ_JointureCentreCourbes(Parametres_local.ToleranceJointuresCentreCourbes);
}

void ConfigVision::on_cmb_type_config_currentIndexChanged(int index)
{
    emit SelectionDomaineParametres(index);
}

void ConfigVision::on_dspb_grille_alignement_valueChanged(double arg1)
{
    Parametres_local.TailleGrille = arg1;
    MAJ_GrilleAlignement(Parametres_local.TailleGrille);
}
