﻿/**
© Florian Joncour, 2013-2018 florian@zetta-sys.com

Ce logiciel est un programme informatique faisant interface à la bibliothèque
Perspective3D, un outil de modélisation 3D à partir de vues orthographiques 2D.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée.  Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard  l'attention de l'utilisateur est attirée sur les risques
associés au chargement,  à l'utilisation,  à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invités à charger  et  tester  l'adéquation  du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.
**/

#include <QSpinBox>
#include <QShowEvent>
#include <QPushButton>
#include "API/Qt/Utils.h"

#include "dialogint.h"

#ifdef DEBUG
#include <QDebug>
#endif

DialogInt::DialogInt(const QString &titre, const QString &txt, int valeur_defaut, int minimum, int maximum, const AnimationQt *anim, bool animation_validation, bool modal, QWidget *parent) :
    QDialog(parent), animation(anim)
{
    ui.setupUi(this);
    Valide = false;
//    setWindowModality(Qt::WindowModal);
    setWindowTitle(titre);
    ui.label->setText(txt);
    ui.spinBox->setMinimum(minimum);
    ui.spinBox->setMaximum(maximum);
    ui.spinBox->setValue(valeur_defaut);
    ui.buttonBox->button(QDialogButtonBox::Ok)->setText(tr("Ok"));
    ui.buttonBox->button(QDialogButtonBox::Ok)->setIcon(QIcon(":/icones/valide.png"));
    ui.buttonBox->button(QDialogButtonBox::Cancel)->setText(tr("Abandonner"));
    ui.buttonBox->button(QDialogButtonBox::Cancel)->setIcon(QIcon(":/icones/invalide.png"));

    Valeur = valeur_defaut;

    if (animation_validation && animation)
    {
        setModal(false);
        show();
        raise();
        activateWindow();
        AttendExec(animation_validation);
    }
    else
    {
        setModal(modal);
        exec();
    }
}

DialogInt::~DialogInt()
{
    ;
}

void DialogInt::showEvent(QShowEvent *ev)
{
    ui.spinBox->setFocus(Qt::TabFocusReason);
    ev->accept();
}

void DialogInt::AttendExec(bool animation_validation)
{
    if (!animation)
    {
        return;
    }
    if (animation_validation && animation->Anime())
    {
        ui.spinBox->setValue(Valeur*2); /* Différent de la valeur par défaut pour animer l'entrée de la valeur. */
        SommeilTempoQt(250);
        animation->ClicWidget(ui.spinBox, 250);
        ui.spinBox->setValue(Valeur);
        animation->ClicWidget(ui.buttonBox->button(QDialogButtonBox::Ok), 250);
        Valide = true;
        close();
    }

    while(isVisible())
    {
        SommeilTempoQt(25);
    }
}

int DialogInt::Reponse() const
{
    return Valeur;
}

bool DialogInt::Accepte() const
{
    return Valide;
}

void DialogInt::on_buttonBox_clicked(QAbstractButton *button)
{
    if (ui.buttonBox->buttonRole(button) == QDialogButtonBox::AcceptRole)
    {
        Valide = true;
        Valeur = ui.spinBox->value();
    }
    else
    {
        Valide = false;
        ui.spinBox->setValue(Valeur);
    }
    close();
}
