﻿/**
© Florian Joncour, 2013-2018 florian@zetta-sys.com

Ce logiciel est un programme informatique faisant interface à la bibliothèque
Perspective3D, un outil de modélisation 3D à partir de vues orthographiques 2D.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée.  Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard  l'attention de l'utilisateur est attirée sur les risques
associés au chargement,  à l'utilisation,  à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invités à charger  et  tester  l'adéquation  du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.
**/

/* Barre des titres des fenêtres alternative et personnalisation du système de fenêtrage. */

#ifndef FENETRAGE_Z6_H
#define FENETRAGE_Z6_H

#include <QWidget>
#include <QDialog>

#include <QPushButton>
#include <QLabel>
#include <QHBoxLayout>
#include <QMainWindow>

int DeplaceEcranSuivantApp(QMainWindow *app); /* Envoi l'application vers l'écran suivant. */
void ChangeEtatPleinEcranApp(QMainWindow *app, bool etat); /* Change le mode plein écran */

class CadreDialog : public QDialog
{
    public:
        CadreDialog(QWidget *parent=0, Qt::WindowFlags f = 0);
        ~CadreDialog();
};

class CadreWidget : public QWidget
{
    public:
        CadreWidget(QWidget *parent=0, Qt::WindowFlags f = 0);
        ~CadreWidget();
};

class BoutonBarreFenetre : public QPushButton
{
        Q_OBJECT

    public:
        BoutonBarreFenetre(QWidget *parent=0);
        ~BoutonBarreFenetre();

        inline const QPoint &DernierePosition() const { return BF_sav_pos; }
        inline bool EtatActivation() const { return etat; }

    private slots:
        void mousePressEvent(QMouseEvent *);
        void mouseReleaseEvent(QMouseEvent *);

    private:
        bool etat;
        QPoint BF_sav_pos;
};

class BarreFenetre : public QWidget
        /* Barre de titre alternative pour les fenêtres (gère le déplacement et la fermeture uniquement). Doit être hérité par une classe pour l'inclure. */
{
        Q_OBJECT

    public:
        BarreFenetre(QWidget *parent);
        ~BarreFenetre();

        void Redim(const QSize &s);

        inline QPushButton *BoutonDeplacement() { return &BF_bouton_deplacement; }
        inline QPushButton *BoutonFermeture() { return &BF_bouton_fermeture; }
        inline void defTitre(const QString &s) { BF_titre.setText(s); }


    private slots:
        void mouseMoveEvent(QMouseEvent *);
        void mousePressEvent(QMouseEvent *);

    private:
        bool BF_etat_deplacement;
        QPoint BF_pos_deplacement;
        QHBoxLayout BF_layout;
        QLabel BF_titre;
        BoutonBarreFenetre BF_bouton_deplacement;
        BoutonBarreFenetre BF_bouton_fermeture;
};

#endif // FENETRAGE_Z6_H
