﻿/**
© Florian Joncour, 2013-2018 florian@zetta-sys.com

Ce logiciel est un programme informatique faisant interface à la bibliothèque
Perspective3D, un outil de modélisation 3D à partir de vues orthographiques 2D.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée.  Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard  l'attention de l'utilisateur est attirée sur les risques
associés au chargement,  à l'utilisation,  à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invités à charger  et  tester  l'adéquation  du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.
**/

/* Objet: Fenêtre des propriétés 3D (une par modèle 3D) */

#ifndef PROPRIETES3D_H
#define PROPRIETES3D_H

#include <QWidget>
#include <QLabel>
#include <QVBoxLayout>
#include <QListWidget>
#include <QTextEdit>
#include <QPlainTextEdit>
#include <QDialog>

#include "fenetrageZ6.h"
#include "animeQt.h"
#include "API/perspective_api.h"

class Proprietes3DPriv_th;
class Interface3d;

class Proprietes3D : public QWidget
{
        friend class Proprietes3DPriv;
        Q_OBJECT
    public:
        Proprietes3D(Perspective3D::Perspective *persp, Perspective3D::PScene3D *scene, int id_style, Interface3d *parent);
        ~Proprietes3D();
        void AfficheProprietesScene_th(); /* Affiche les propritées de la scène (exécution d'un thread). */
        void AfficheProprietesScene(); /* Affiche les propritées de la scène. */
        void AfficheInfosPoint(const Perspective3D::Ppoint3D &p); /* Affiche dans l'interface les informations sur un point. */
        void AfficheInfosPoint(const Perspective3D::PSommet3D &p); /* Affiche dans l'interface les informations sur un point. */
        void AfficheInfosLigne(const Perspective3D::Pligne3D &l); /* Affiche dans l'interface les informations sur une ligne. */
        void AfficheInfosLigne(const Perspective3D::PSegment3D &l); /* Affiche dans l'interface les informations sur une ligne. */
        void AfficheInfosSurface(const Perspective3D::PSurface3D &s); /* Affiche les infos d'une surface. */
        void AfficheInfosSolide(const Perspective3D::PSolide3D &s, int id); /* Affiche les infos d'un solide. */
        void defTexteConsole(const QString &s);
        void DefileTexteConsole() const;
        void AjoutConsole(const QString &s); /* Ajoute du texte dans la console. */
        void Nettoyage();

    private:
        void Ajout_propriete(const QString &prop, const QString &val);
        void Ajout_propriete(const QString &prop, const QString &val, const QString &suffix);

        const Perspective3D::Perspective *perspective;
        const Perspective3D::PScene3D *scene_p3d;
        Interface3d *Parent;
        QFrame *Separateur_console;
        QVBoxLayout *layoutconsole;
        QPlainTextEdit *console;
        QVBoxLayout *layout_props;
        QHBoxLayout *horizontalLayout_infos;
        QListWidget *Proprietes;
        QVBoxLayout *layoutinfos_selection;
        QVBoxLayout *layoutlistepoints;
        QListWidget *listepoints;
        QVBoxLayout *layoutlistelignes;
        QListWidget *listelignes;
        QVBoxLayout *layoutlistesurfaces;
        QListWidget *listesurfaces;
        QTextEdit   *ted_infos_selection;
        QVBoxLayout *layoutlistesolides;
        QListWidget *listesolides;
        QSpacerItem *espacement1;
        QSpacerItem *espacement2;

        Proprietes3DPriv_th *priv_th;

    private slots:
        void SelectionPoint(int id);
        void SelectionSegment(int id);
        void SelectionSurface(int id);
        void SelectionSolide(int id);

        void SupprimePoint(QListWidgetItem *it);
        void SupprimeLigne(QListWidgetItem *it);
        void SupprimeSurface(QListWidgetItem *it);
        void SupprimeSolide(QListWidgetItem *it);

        void SelectionPoint(QListWidgetItem *it);
        void SelectionSegment(QListWidgetItem *it);
        void SelectionSurface(QListWidgetItem *it);
        void SelectionSolide(QListWidgetItem *it);
};

class Proprietes3D_widget : public QWidget
{
        Q_OBJECT
    public:
        Proprietes3D_widget(Perspective3D::Perspective *persp, Perspective3D::PScene3D *scene, int id_style, Interface3d *parent);
        ~Proprietes3D_widget();

        inline Proprietes3D &widget() const { return *props_w; }

    private slots:
        void showEvent(QShowEvent *ev);

    private:
        Interface3d *Parent;
        Proprietes3D *props_w;
};

class Proprietes3D_dock : public CadreDialog
{
        Q_OBJECT
    public:
        Proprietes3D_dock(Perspective3D::Perspective *persp, Perspective3D::PScene3D *scene, int id_style, Interface3d *parent);
        ~Proprietes3D_dock();

        inline Proprietes3D &widget() const { return *props_w; }

    private slots:
        void showEvent(QShowEvent *ev);

    private:
        Interface3d *Parent;
        Proprietes3D *props_w;
};

#endif // PROPRIETES3D_H
