#!/bin/sh

DESTDIR_root=/opt/Zetta6
LOCALDIR_root=/usr/local

DESTDIR_user=$HOME/.local/Zetta6
LOCALDIR_user=$HOME/.local

function install_z6 {
    DESTDIR=$1
    LOCALDIR=$2

    mkdir -p $DESTDIR
    cp -rv * $DESTDIR/
    chmod -R 755 $DESTDIR/
    
    mkdir -p -m 755 $LOCALDIR/share/applications/
    echo "[Desktop Entry]
Hidden=false
Exec=\"$LOCALDIR/bin/Zetta6\"
Icon=$LOCALDIR/share/icons/perspective3d.png
Type=Application
NoDisplay=false
Version=1.0.7
MimeType=text/z6s;application/dxf;image/vnd.dxf;
StartupNotify=false
Comment[fr_FR]=Modeleur par conversion 2D/3D
Comment=3D Modeling by converting 2D sketchs
DBusActivatable=false
Categories=Graphics;2DGraphics;3DGraphics;RasterGraphics;
Terminal=false
Name[fr_FR]=Zetta6
Name=Zetta6
GenericName=Zetta6
GenericName[fr_FR]=Zetta6" > $LOCALDIR/share/applications/Zetta6.desktop
    
    mkdir -p -m 755 $LOCALDIR/share/appdata/
echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<component type=\"desktop\">
    <id>Zetta6.desktop</id>
    <metadata_license>CC0-1.0</metadata_license>
    <project_license>CECILL-C and Proprietary</project_license>
    <name>Zetta 6</name>
    <summary>3D Modeling by converting 2D sketchs</summary>
    <description>
        <p>Zetta6 is a 3D modeling software mainly by (automaticaly) converting 2D drawings to 3D.</p>
        <p>The software can import DXF files and export models to some formats like STL, OBJ or AMF (for 3D printing).</p>
    </description>
    <screenshots>
        <screenshot type=\"default\">
            <image>http://www.zetta-sys.com/apercu_zetta6.png</image>
            <caption>3D Eiffel tower with her sketch</caption>
        </screenshot>
    </screenshots>
    <url type=\"homepage\">http://www.zetta-sys.com/</url>
    <update_contact>florian_at_zetta-sys.com</update_contact>
</component>
" > $LOCALDIR/share/appdata/Zetta6.appdata.xml
    
    mkdir -p -m 755 $LOCALDIR/share/mime/packages/
    echo "<?xml version=\"1.0\" encoding=\"UTF-8\"?>
<mime-info xmlns=\"http://www.freedesktop.org/standards/shared-mime-info\">
    <mime-type type=\"text/z6s\">
        <comment>Zetta6 script</comment>
        <glob pattern=\"*.z6s\"/>
        <!-- <glob pattern=\"*.Z6s\"/> -->
    </mime-type>
</mime-info>
" > $LOCALDIR/share/mime/packages/text-z6s.xml
    
    mkdir -p -m 755 $LOCALDIR/share/icons/
    cp -v $DESTDIR/perspective3d.png $LOCALDIR/share/icons/
    
    echo "#!/bin/sh
cd $DESTDIR
export QT_LOGGING_RULES=qt.network.ssl.warning=false
./Zetta6.sh \$*" > $LOCALDIR/bin/Zetta6
    chmod +x $LOCALDIR/bin/Zetta6
    
    update-desktop-database $LOCALDIR/share/applications/
    update-mime-database $LOCALDIR/share/mime/
}

function uninstall_z6 {
    DESTDIR=$1
    LOCALDIR=$2
    
    rm -rvf $DESTDIR
    rm -vf $LOCALDIR/bin/Zetta6
    rm -vf $LOCALDIR/share/applications/Zetta6.desktop
    rm -vf $LOCALDIR/share/appdata/Zetta6.appdata.xml
    rm -vf $LOCALDIR/share/mime/packages/text-z6s.xml
    rm -vf $LOCALDIR/share/icons/perspective3d.png
}

function ask_user {
    DESTDIR=$1
    LOCALDIR=$2

    if [ ! -d "$DESTDIR" ]; then
        read -p  "Install to $DESTDIR ? (y/Y) " -n 1 -r
        echo ""
        if [[ $REPLY =~ ^[Yy]$ ]]
        then
            install_z6 $DESTDIR $LOCALDIR
        else
            echo "Exiting..."
        fi
    else
        read -p "Uninstall from $DESTDIR ? (y/Y) " -n 1 -r
        echo ""
        if [[ $REPLY =~ ^[Yy]$ ]]
        then
            uninstall_z6 $DESTDIR $LOCALDIR
        else
            echo "Exiting..."
        fi
    fi
}

if [ ! -d "$DESTDIR_root" ] && [ ! -d "$DESTDIR_user" ]; then
    if [[ $EUID -ne 0 ]]; then
        echo "Installing as single user. Run this script as root for standard installation."
        ask_user $DESTDIR_user $LOCALDIR_user
    else
        ask_user $DESTDIR_root $LOCALDIR_root
    fi
elif [ ! -d "$DESTDIR_root" ]; then
    ask_user $DESTDIR_user $LOCALDIR_user
else
    if [[ $EUID -ne 0 ]]; then
        echo "Uninstall : You must be root to uninstall from $DESTDIR_root"
        su -c "$0 $*"
        exit 0
    else
        ask_user $DESTDIR_root $LOCALDIR_root
    fi
fi
