﻿/*
 * Enregistrement de fichier GIF (animé ou pas) à partir d'un ensemble dimages de type QImage (bibliothèque Qt).
 *   Code dans le domaine publique à l'instar de jo_gif, sur lequel il est basé.
 *   Florian Joncour, Janvier 2016.
*/

#ifndef Z_GIF_H
#define Z_GIF_H

#include <QString>
#include <QImage>

struct jo_gif_s;

class ZGif
{
    public:
        ZGif(const char *nom_fichier, short taille_x, short taille_y, short nombre_boucles=0, short delai_images=10);
        /* Créé une nouvelle image GIF, d'après le nom, et les dimensions (taille_x=largeur, taille_y=hauteur).
            Si le nombre de boucle vaut 0, le gif sera animé à l'infini, sinon il bouclera jusqueà la valeur donnée.
            Le délai entre les images est exprimé en centième de secondes. */

        ~ZGif();
        /* Destructeur, incidemment fermeture du fichier. */

        void AjoutImage(const QImage &image, short delai=0);
        /* Insert une image dans le fichier (tableau dont les pixels se suivent et représentés par 4 octets (Rouge, Vert, Bleu, Alpha)).
            Si le delai est nul, le temps entre cette image et la suivante sera le délai général, donné dans le constucteur.
                Dans le cas contraire, on utilisera le temps donné en paramètre de la fonction. */

    protected:
        jo_gif_s *Gif;
        short DelaiImages;
};

#endif // Z_GIF_H
