message("Perspective_api pour projet: $${TARGET}")

# Définition de la version de la bibliothèque Perspective3D:
VER_MAJ_P3D = 1   #  Majeur
VER_MIN_P3D = 0   #  Mineur
VER_PAT_P3D = 7   #  Correctif

VERSION_P3D = $$VER_MAJ_P3D"."$$VER_MIN_P3D"."$$VER_PAT_P3D

DEFINES += VERSION_P3D_MAJEUR=\"$$VER_MAJ_P3D\"
DEFINES += VERSION_P3D_MINEUR=\"$$VER_MIN_P3D\"
DEFINES += VERSION_P3D_REVISION=\"$$VER_PAT_P3D\"
DEFINES += VERSION_P3D_STR=\\\"$$VERSION_P3D\\\"

message ("Version Perspective3D :: "$$VERSION_P3D)

# $$CHEMIN_PERSPECTIVE Doit être défini dans le projet parent.
CHEMIN_API_PERSPECTIVE = $$CHEMIN_PERSPECTIVE/API/

CONFIG(debug, debug|release) {
    DEFINES += DEBUG_API_P3D
}

INCLUDEPATH += $$CHEMIN_PERSPECTIVE
INCLUDEPATH += $$CHEMIN_API_PERSPECTIVE

HEADERS += $$CHEMIN_API_PERSPECTIVE/perspective_types.h \
    $$CHEMIN_API_PERSPECTIVE/perspective_sys.h  \
    $$CHEMIN_API_PERSPECTIVE/perspective_api.h  \
    $$CHEMIN_API_PERSPECTIVE/perspective_def.h  \
    $$CHEMIN_API_PERSPECTIVE/perspective_div2.h

SUPPORT_GL { # Support pour l'interface OpenGL
#    unix:LIBS += -lGLEW
#    win32:LIBS += -lglew32
    unix:LIBS += -lGL -lGLU
    win32:LIBS += -lglu32 -lopengl32
    SOURCES += $$CHEMIN_API_PERSPECTIVE/GL/perspective_gl.cpp
    HEADERS += $$CHEMIN_API_PERSPECTIVE/GL/perspective_gl.h
    DEFINES += SUPPORT_GL
    message("  $${TARGET}+Perspective3D : Support OpenGL")
}

SUPPORT_EVAL_EXP { # Support du langage d'évaluation
    INCLUDEPATH += $$CHEMIN_API_PERSPECTIVE/eval_exp/
    SOURCES += $$CHEMIN_API_PERSPECTIVE/eval_exp/eval_exp.cpp
    HEADERS += $$CHEMIN_API_PERSPECTIVE/eval_exp/eval_exp.h
    QMAKE_CXXFLAGS -= -std=c++11
    QMAKE_CXXFLAGS += -std=c++11
    message("  $${TARGET}+Perspective3D : Support Eval-Exp")
}

SUPPORT_QT { # Support de la conversion de certains types Perspective3D vers Qt
    INCLUDEPATH += $$CHEMIN_API_PERSPECTIVE/Qt/
    HEADERS += $$CHEMIN_API_PERSPECTIVE/Qt/Conversion.h
    HEADERS += $$CHEMIN_API_PERSPECTIVE/Qt/Utils.h
    SOURCES += $$CHEMIN_API_PERSPECTIVE/Qt/Utils.cpp
}

# Liaison automatique avec la bibliothèque précompilée si elle est présente (Linux):
!contains(DEFINES, INTERNE_PERSPECTIVE3D) {
    unix {
        exists("../linux-$${QMAKE_HOST.arch}/libPerspective3D.so") {
            message("  $${TARGET} : Utilisation d'une version précompilée de Perspective3D")
            LIBS += -L$$CHEMIN_PERSPECTIVE/linux-$${QMAKE_HOST.arch}/ -lPerspective3D
        } else {
            LIBS += -L$$DESTDIR/ -lPerspective3D
        }
    }
    win32 {
        message("  $${TARGET} : Utilisation d'une version précompilée de Perspective3D (Windows)")
        LIBS += -L$$DESTDIR/ libPerspective3D.dll
    }
}
