﻿/**
© Florian Joncour, 2013-2018 florian@zetta-sys.com

Ce logiciel est un programme informatique faisant interface à la bibliothèque
Perspective3D, un outil de modélisation 3D à partir de vues orthographiques 2D.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée.  Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard  l'attention de l'utilisateur est attirée sur les risques
associés au chargement,  à l'utilisation,  à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invités à charger  et  tester  l'adéquation  du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.
**/

#ifndef QSELECTCOULEUR_H
#define QSELECTCOULEUR_H

#include <QWidget>
#include <QHBoxLayout>
#include <QVBoxLayout>
#include <QSlider>
#include <QLabel>
#include <QImage>
#include <QPoint>
#include <QLabel>
#include <QSpinBox>
#include <QCheckBox>
#include <QPushButton>

//#ifdef Q_OS_UNIX
    #define QSC_CAPTURE_PIXEL_ECRAN
    #include <QMouseEvent>
//#endif

/* Widget de sélection de couleur. */

namespace QSelectCouleur_priv
{
    class ConteneurImage256 : public QLabel
    {
            /* Sélecteur de couleur poly-chrome */
            Q_OBJECT
        public:
            ConteneurImage256(bool mode_minature, QWidget *parent = 0);
            void AssigneIntensite(unsigned char val_bleu=255, bool monochrome=false, bool force_mise_a_jour=false);
            void defCouleur(QRgb couleur, bool monochrome=false, bool force_mise_a_jour=false);
            void defLectureSeule(bool lecture_seule);
            QRgb PixelCourant() const;

            void defToolTip(const QString &s);

            int HauteurConteneur() const;
            int LargeurConteneur() const;

        signals:
            void SelectionPixel(QRgb);

        protected:
            void mousePressEvent(QMouseEvent *ev);
            void mouseMoveEvent(QMouseEvent *ev);

        private:
            int TailleMatrice() const;
            int TailleRectSelection_Y() const;
            int convCoord(int i, bool ignore_image_miniature=false) const;
            void GenImage(bool mise_a_jour_couleurs=true);

            void Active();
            void Desactive();
            inline bool Actif() const { return etat; }

            const bool mode_image_miniature;
            bool etat;
            bool etat_lecture_seule;
            bool pix_monochrome;
            QImage image_couleurs;
            QImage image_rendu;
            QPoint position_courante;
            unsigned char intensite_bleu;
    };

    class SelectCouleurMono : public QWidget
    {
            /* Sélecteur de couleur mono-chrome */
            Q_OBJECT
        public:
            SelectCouleurMono(bool mode_miniature, QRgb type, QWidget *parent=0);
            void defValCouleur(int val, bool desactive_mise_a_jour=false);
            int valCouleur() const;
            void defToolTip(const QString &s);

        signals:
            void SelectionValeur(int);

        private slots:
            void ModifCouleur(int);

        private:
            const bool mode_image_miniature;
            bool desactive_mise_a_jour_;
            QHBoxLayout layout_select;
            QSpinBox spb;
            QLabel lbl;
            QRgb type_couleur;
    };
}

class QSelectCouleur : public QWidget
{
        Q_OBJECT
    public:
        explicit QSelectCouleur(bool mode_miniature, QWidget *parent = 0);

        void defCouleur(QRgb couleur);
        bool RestaureCouleur();

        QRgb Couleur() const;

        int HauteurWidget() const;

    signals:
        void NouvelleCouleur(QRgb);

    private slots:
        void changeCouleur(int val);
        void changeEtatMonochrome(bool etat);
        void SelectionPixel(QRgb couleur);
        void SelectionRouge(int val);
        void SelectionVert(int val);
        void SelectionBleu(int val);

        void BaisseContraste();
        void MonteContraste();

        void Clic_restaure_couleur();

#ifdef QSC_CAPTURE_PIXEL_ECRAN
        void mouseMoveEvent(QMouseEvent *e);
        void mousePressEvent(QMouseEvent *e);
        void keyPressEvent(QKeyEvent *e);
        void Clic_capture_pixel_ecran();
#endif

    protected:
        void defCouleurInt(QRgb couleur, bool ignore_mono_chrome=false, bool force_mise_a_jour=false);

#ifdef QSC_CAPTURE_PIXEL_ECRAN
        QRgb CapturePixelEcran(const QPoint &pos) const;
        void TermineCapturePixelEcran();
        void CommenceCapturePixelEcran();
#endif

    private:
        QSelectCouleur_priv::ConteneurImage256 image;
        QRgb couleur_sav;
        const bool active_selecteurs;

        QVBoxLayout layout_v;
        QHBoxLayout layout_h;
        QVBoxLayout layout_palette;
        QHBoxLayout layout_image;
        QVBoxLayout layout_intensite;
        QVBoxLayout layout_select_couleurs;

        QSelectCouleur_priv::SelectCouleurMono select_rouge;
        QSelectCouleur_priv::SelectCouleurMono select_vert;
        QSelectCouleur_priv::SelectCouleurMono select_bleu;
        QHBoxLayout layout_boutons_contraste;
        QPushButton bouton_contraste_moins;
        QPushButton bouton_contraste_plus;
        QCheckBox chk_monochrome;
        QSlider slider_v;

        QPushButton bouton_restaurer_couleur;

#ifdef QSC_CAPTURE_PIXEL_ECRAN
        QPushButton bouton_capture_pixel_ecran;
        bool etat_capture_pixel_ecran;
#endif
};

#endif // QSELECTCOULEUR_H
