uniform mat4 matModel;
uniform mat4 matProjections;
uniform vec3 LightPos;
attribute vec3 Vertex;
attribute vec3 Normal;

varying vec4 color;
varying float intensity;

void main(void)
{
    vec3 lum = LightPos;
    color = gl_Color;
    intensity = dot(normalize(lum-Vertex), Normal);

    gl_Position = matProjections * matModel * vec4(Vertex, 1);
}
