uniform mat4 matModel;
uniform mat4 matProjections;
uniform mat4 matNormals;
uniform vec3 LightPos;
attribute vec3 Vertex;
attribute vec3 Normal;

varying vec3 objectColor;
varying vec3 normal;
varying vec3 light_pos;

void main(void)
{
    mat4 mvp = matProjections * matModel;
    light_pos = (mvp * vec4(LightPos, 1)).xyz;
    normal = normalize(vec3(matNormals * vec4(Normal, 0)));
    objectColor = gl_Color.xyz;
    gl_Position = mvp * vec4(Vertex, 1);
}
