﻿#include <QMouseEvent>
#include <QDesktopWidget>

#include "style.h"
#include "fenetrageZ6.h"

#ifdef DEBUG
#include <QDebug>
#endif

int DeplaceEcranSuivantApp(QMainWindow *app)
/* Déplace vers l'écran suivant sur la pile... */
{
    QDesktopWidget *e = QApplication::desktop();

    const int nombre_ecrans = e->screenCount();
    if (nombre_ecrans < 2)
    {
        return 0; // Rien à faire...
    }

    int id_ecran_courant = e->screenNumber(app);

    int id_ecran_suivant = (id_ecran_courant+1) % nombre_ecrans;
    const QRect geom_ecran_suivant = e->screenGeometry(id_ecran_suivant);

//    qDebug() << "DeplaceEcranSuivantApp : e=" << e->screenNumber(app) << " / " << e->screenCount() << " (" << id_ecran_suivant << ")";
//    qDebug() << "                   :: " << geom_ecran_suivant;

    app->resize(geom_ecran_suivant.width(), geom_ecran_suivant.height());
    app->move(geom_ecran_suivant.x(), geom_ecran_suivant.y());
    return id_ecran_suivant - id_ecran_courant;
}

bool PleinEcranApp(const QMainWindow *app)
{
#ifdef Q_OS_WIN
    /* Spécifique Windows, voir ChangeEtatPleinEcranApp() */

//    return app->isFullScreen();
//    return app->windowFlags() & Qt::FramelessWindowHint;
    return app->isMaximized();
#else
    return app->isFullScreen();
#endif // Q_OS_WIN
}

void ChangeEtatPleinEcranApp(QMainWindow *app, bool etat)
/* Change le mode plein écran */
{
#ifdef Q_OS_WIN
//#if 1
    /* Spécifique Windows, en mode *vrai* plein écran, les fenêtres filles ne sont pas affichées en premier plan dans certaines configurations.
        https://bugreports.qt.io/browse/QTBUG-39220
        https://bugreports.qt.io/browse/QTBUG-7556
    */

#if 0
//    const Qt::WindowFlags drapeaux_plein_ecran = Qt::FramelessWindowHint;
    const Qt::WindowFlags drapeaux_plein_ecran = Qt::FramelessWindowHint | Qt::NoDropShadowWindowHint | Qt::MaximizeUsingFullscreenGeometryHint;
#endif // 1

    if (etat)
    {
    #if 0 /* Vrai plein écran */
        app->setAttribute(Qt::WA_Mapped);
        app->setWindowState(Qt::WindowFullScreen);
    #else
//        app->setWindowFlags(app->windowFlags() | drapeaux_plein_ecran);
//        app->setWindowState(Qt::WindowMaximized);

        app->showMaximized();
    #endif // 0
    }
    else
    {
    #if 0
        app->setWindowState(Qt::WindowMaximized);
    #else
//        app->setWindowFlags(app->windowFlags() & (~drapeaux_plein_ecran));
//        app->setWindowState(Qt::WindowMaximized);

        app->showNormal();
    #endif // 0
    }
#else
    app->setWindowState(etat ? Qt::WindowFullScreen : Qt::WindowMaximized);
#endif // Q_OS_WIN

    app->show();
}

CadreDialog::CadreDialog(QWidget *parent, Qt::WindowFlags f) : QDialog(parent)
{
//    setWindowFlags(f | Qt::Dialog | Qt::WindowStaysOnTopHint | Qt::FramelessWindowHint);

#ifdef Q_OS_UNIX
    setWindowFlags(f | Qt::FramelessWindowHint | Qt::ToolTip | Qt::WindowStaysOnTopHint | Qt::CustomizeWindowHint);
#else
    setWindowFlags(f | Qt::Tool | Qt::FramelessWindowHint | Qt::CustomizeWindowHint);
#endif // Q_OS_UNIX

    setAttribute(Qt::WA_Moved);
    setObjectName("cadre"); /* Voir la feuille de style... */
}

CadreDialog::~CadreDialog()
{
}

CadreWidget::CadreWidget(QWidget *parent, Qt::WindowFlags f) : QWidget(parent)
{
    setWindowFlags(f | Qt::Widget | Qt::WindowStaysOnTopHint | Qt::FramelessWindowHint | Qt::CustomizeWindowHint);
    setObjectName("cadre"); /* Voir la feuille de style... */
}

CadreWidget::~CadreWidget()
{
}

BoutonBarreFenetre::BoutonBarreFenetre(QWidget *parent) : QPushButton(parent), etat(false)
{
}

BoutonBarreFenetre::~BoutonBarreFenetre()
{
    ;
}

void BoutonBarreFenetre::mousePressEvent(QMouseEvent *e)
{
    BF_sav_pos = e->windowPos().toPoint();

    etat = true;
    e->ignore();
}

void BoutonBarreFenetre::mouseReleaseEvent(QMouseEvent *e)
{
    etat = false;
    e->ignore();
}

BarreFenetre::BarreFenetre(QWidget *parent) : QWidget(parent),
    BF_etat_deplacement(false), BF_pos_deplacement(0,0),
    BF_layout(), BF_titre(),
    BF_bouton_deplacement(), BF_bouton_fermeture()
{
    const int taille_boutons = 22;

//    window()->setWindowFlags(Qt::FramelessWindowHint);

    setMinimumHeight(taille_boutons+taille_boutons);

    setLayout(&BF_layout);
    BF_layout.addWidget(&BF_titre);
    BF_layout.addWidget(&BF_bouton_deplacement);
    BF_layout.addWidget(&BF_bouton_fermeture);

    BF_titre.setText("");
    BF_titre.setAlignment(Qt::AlignCenter);
    BF_bouton_deplacement.setText("#");
    BF_bouton_fermeture.setText("X");

    BF_bouton_deplacement.setMaximumSize(QSize(taille_boutons, taille_boutons));
    BF_bouton_fermeture.setMaximumSize(QSize(taille_boutons, taille_boutons));

    BF_bouton_deplacement.resize(taille_boutons, taille_boutons);
    BF_bouton_fermeture.resize(taille_boutons, taille_boutons);

    BF_bouton_deplacement.setObjectName("BFTitre");
    BF_bouton_fermeture.setObjectName("BFTitre");

    ChargeStyleWidget(*this, 5);

    Redim(parent->size());
}

BarreFenetre::~BarreFenetre()
{
    ;
}

void BarreFenetre::mouseMoveEvent(QMouseEvent *ev)
{
    if (BF_bouton_deplacement.EtatActivation())
    {
        window()->move(ev->globalPos()-BF_bouton_deplacement.DernierePosition());
        ev->accept();
    }
}

void BarreFenetre::mousePressEvent(QMouseEvent *ev)
{
    if (BF_bouton_fermeture.EtatActivation())
    {
        window()->close();
        ev->accept();
    }
}

void BarreFenetre::Redim(const QSize &s)
{
    const int marge_fenetre = 3;
    resize(s.width(), BF_bouton_fermeture.height()+marge_fenetre);
    if (s.width() > 24 && s.height() > 20)
    {
        BF_bouton_fermeture.move(s.width() - BF_bouton_fermeture.width()-marge_fenetre, marge_fenetre);
        BF_bouton_deplacement.move(BF_bouton_fermeture.pos().x()-(BF_bouton_deplacement.width()+marge_fenetre), marge_fenetre);
    }
    else
    {
        BF_bouton_deplacement.move(marge_fenetre, marge_fenetre);
        BF_bouton_fermeture.move(BF_bouton_deplacement.width()+BF_bouton_deplacement.pos().x()+marge_fenetre, marge_fenetre);
    }
}
