uniform sampler2D Texture;
uniform vec2 Resolution;
uniform float Time;
uniform vec3 BackgroundColor;
varying vec2 f_texcoord;

const bool anime_radial = false;

float ValTempo()
{
    float r = sin(Time)*0.85;
    return (r+9.0);
}

void main(void)
{
    float ratio = (Resolution.x / Resolution.y);
    float fxy = 0.0;
    if (f_texcoord.x < 0.5)
    {
        if (f_texcoord.y < 0.5)
            fxy = dot(f_texcoord.x, f_texcoord.y*ratio);
        else
            fxy = dot(f_texcoord.x, ((1.0-f_texcoord.y)*ratio));
    }
    else
    {
        if (f_texcoord.y < 0.5)
            fxy = dot((1.0-f_texcoord.x), f_texcoord.y*ratio);
        else
            fxy = dot((1.0-f_texcoord.x), ((1.0-f_texcoord.y)*ratio));
    }

    if (anime_radial)
        fxy = sqrt( fxy * (ValTempo()) );
    else
        fxy = sqrt( fxy * (8.0) );
    fxy = clamp(fxy, 0.5, 1.0);
    gl_FragColor = (texture2D(Texture, f_texcoord) * (fxy));
}
