﻿/**
© Florian Joncour, 2013-2018 florian@zetta-sys.com

Ce logiciel est un programme informatique faisant interface à la bibliothèque
Perspective3D, un outil de modélisation 3D à partir de vues orthographiques 2D.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée.  Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard  l'attention de l'utilisateur est attirée sur les risques
associés au chargement,  à l'utilisation,  à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invités à charger  et  tester  l'adéquation  du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.
**/

/* Classe lecture fichiers WAVE. */

#ifndef QAUDIOWAVE_H
#define QAUDIOWAVE_H

#include <QString>
#include <QAudioFormat>
#include <QByteArray>
#include <QObject>
#include <QThread>
#include <QMutex>
#include <QAudio>

class QAudioOutput;
class QIODevice;
class QAudioDeviceInfo;

namespace ExecAudio
{
    enum ERREURS_LECTURE_AUDIO { ERR_VALIDE=0, ERR_TAMPON_VIDE, ERR_IO, ERR_OCCUPE, ERR_ARRET };
    int ExecAudioPCM(const char *tampon_fichier, unsigned long debut_lecture_tampon, unsigned long fin_lecture_tampon, unsigned long taille_periode, QIODevice *fichier_audio, bool *arret=0);

    class ExecAudio_th : public QThread
    {
            Q_OBJECT

        public:
            ExecAudio_th(const char *tampon_fichier_, unsigned long debut_lecture_tampon_, unsigned long fin_lecture_tampon_, unsigned long taille_periode_, QIODevice *fichier_audio_);

            void run();
            bool EnCours() const;
            int ValeurRetour() const { return etat_lecture; }
            void Stop();
            void AttendFinLecture() const;

        signals:
            void FinLecture(int etat, QAudio::Error);

        private:
            const char *tampon_fichier;
            unsigned long debut_lecture_tampon;
            unsigned long fin_lecture_tampon;
            unsigned long taille_periode;
            QIODevice *fichier_audio;
            int etat_lecture;
            bool arret_lecture;
    };
}

class qAudioWave : public QObject
{
        Q_OBJECT

    public:
        qAudioWave();
        qAudioWave(const QString chemin_fichier);
        ~qAudioWave();

        bool Charge(const QString &chemin);
        /* Chargement d'un fichier WAVE. */

        bool Lecture(const QAudioDeviceInfo *peripherique, qreal volume_r=-1., bool bloquant=true);
        /* Lecture du fichier (après chargement). */

        bool LectureEnCours() const;
        /* Renvoi true si une lecture est en cours. */

        inline void defVolume(qreal v) { volume=v; }
        inline qreal Volume() const { return volume; }

        inline bool ValideChargement() const { return valide_chargement; }
        inline bool ValideLecture() const { return valide_lecture; }
        inline const QString &DerniereErreur() const { return mesg_erreur; }

    signals:
        void FinLecture(bool);
        /* Signal émis après la fin de la lecture du dernier appel à la fonction Lecture().
            Le booléen contient l'état de la dernière lecture, donc true si tout s'est bien passé, sinon false. */

    private slots:
        void FinLecture_th(const int, const QAudio::Error);

    private:
        inline void AjoutErreur(const QString &mesg) { mesg_erreur += (mesg + QString("\n")); }
        bool ExecLecture(const QAudioDeviceInfo *peripherique, qreal volume_r, bool bloquant);
        bool Nettoyage();

        bool valide_chargement;
        bool valide_lecture;
        QAudioOutput *audio;
        QIODevice *fichier_audio;
        ExecAudio::ExecAudio_th *th_lecture;
        QMutex mutex_audio;
        QByteArray donnes;
        QAudioFormat format;
        unsigned long debit_octs_secs;
        unsigned long  debut_donnes;
        unsigned long  fin_donnes;
        qreal volume;
        QString mesg_erreur;
};

#endif // QAUDIOWAVE_H
