﻿/*
 * Enregistrement de fichier GIF (animé ou pas) à partir d'un ensemble dimages de type QImage (bibliothèque Qt).
 *   Code dans le domaine publique à l'instar de jo_gif, sur lequel il est basé.
 *   Florian Joncour, Janvier 2016.
*/

#include "jo_gif.h"
#include "zGIF.h"

ZGif::ZGif(const char *nom_fichier, short taille_x, short taille_y, short nombre_boucles, short delai_images)
/* Créé une nouvelle image GIF, d'après le nom, et les dimensions (taille_x=largeur, taille_y=hauteur).
    Si le nombre de boucle vaut 0, le gif sera animé à l'infini, sinon il bouclera jusqueà la valeur donnée. */
{
    DelaiImages = delai_images;
    Gif = new jo_gif_t;
//    *Gif = jo_gif_start(nom_fichier, taille_x, taille_y, nombre_boucles, 31);
    *Gif = jo_gif_start(nom_fichier, taille_x, taille_y, nombre_boucles, 255);
}

void ZGif::AjoutImage(const QImage &image, short delai)
/* Insert une image dans le fichier (tableau dont les pixels se suivent et représentés par 4 octets (Rouge, Vert, Bleu, Alpha)).
    Si le delai est nul, le temps entre cette image et la suivante sera le délai général, donné dans le constucteur.
        Dans le cas contraire, on utilisera le temps donné en paramètre de la fonction. */
{
    jo_gif_frame(Gif, image.constBits(), ((delai>0) ? delai : DelaiImages), false);
}

ZGif::~ZGif()
/* Destructeur, incidemment fermeture du fichier. */
{
    jo_gif_end(Gif);
    delete Gif;
}
