﻿/**
© Florian Joncour, 2013-2018 florian@zetta-sys.com

Ce logiciel est un programme informatique faisant interface à la bibliothèque
Perspective3D, un outil de modélisation 3D à partir de vues orthographiques 2D.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée.  Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard  l'attention de l'utilisateur est attirée sur les risques
associés au chargement,  à l'utilisation,  à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invités à charger  et  tester  l'adéquation  du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.
**/

#ifndef VERSION_H
#define VERSION_H

#define STR_HELPER_ZVERSION(x) #x /* Conversion en caractères de la valeur/variable en chaîne de caractère. */
#define STR_ZVERSION(x) STR_HELPER_ZVERSION(x) /* Force l'expension de la macro (donc récupère la valeur entière). */

#define VERSION_Z6_STR STR_ZVERSION(VERSION_P3D_MAJEUR) "." STR_ZVERSION(VERSION_P3D_MINEUR) "." STR_ZVERSION(VERSION_P3D_REVISION)

#define VER_FILEVERSION             VER_PRODUCTVERSION
#define VER_PRODUCTVERSION          VERSION_P3D_MAJEUR,VERSION_P3D_MINEUR,VERSION_P3D_REVISION,0

#define VER_PRODUCTVERSION_STR    VERSION_Z6_STR
#define VER_COMPANYNAME_STR         "Zetta Syst\xE8mes"
#define VER_FILEDESCRIPTION_STR     "Logiciel Zetta6"
#define VER_INTERNALNAME_STR        "Zetta6"
#define VER_LEGALCOPYRIGHT_STR      "2013-2018 Florian Joncour"
#define VER_LEGALTRADEMARKS1_STR    "Tous droits r\xE9serv\xE9s"
#define VER_LEGALTRADEMARKS2_STR    "\0"
#define VER_ORIGINALFILENAME_STR    "Zetta6.exe"
#define VER_PRODUCTNAME_STR         "Zetta6"
#define VER_COMPANYDOMAIN_STR       "https://zetta-sys.com"

#define VER_PRODUCTVERSION_STR_0      VER_PRODUCTVERSION_STR "\0"
#define VER_COMPANYNAME_STR_0         VER_COMPANYNAME_STR "\0"
#define VER_FILEDESCRIPTION_STR_0     VER_FILEDESCRIPTION_STR "\0"
#define VER_INTERNALNAME_STR_0        VER_INTERNALNAME_STR "\0"
#define VER_LEGALCOPYRIGHT_STR_0      VER_LEGALCOPYRIGHT_STR "\0"
#define VER_LEGALTRADEMARKS1_STR_0    VER_LEGALTRADEMARKS1_STR "\0"
#define VER_LEGALTRADEMARKS2_STR_0    VER_LEGALTRADEMARKS2_STR "\0"
#define VER_ORIGINALFILENAME_STR_0    VER_ORIGINALFILENAME_STR "\0"
#define VER_PRODUCTNAME_STR_0         VER_PRODUCTNAME_STR "\0"
#define VER_COMPANYDOMAIN_STR_0       VER_COMPANYDOMAIN_STR "\0"

#endif // VERSION_H
