﻿#include "wnotifications.h"
#include "style.h"

#ifdef DEBUG
#include <QDebug>
#endif // DEBUG

WNotifications::WNotifications(QWidget *parent) : QWidget(parent), id_timer_fermeture(-1)
{
    ui.setupUi(this);
//    setAutoFillBackground(false);
}

void WNotifications::AfficheNotification(const QString &texte, IconeNotifications type_icone, bool fermeture_auto, QWidget *reference_widget)
{
    if (type_icone == IconeNotifications::ICONE_NOTIFICATION_NUL)
    {
        ui.lbl_icone->clear();
        ui.widget_icone->hide();
    }
    else
    {
        if (type_icone == IconeNotifications::ICONE_NOTIFICATION_ATTENTION)
        {
            ui.lbl_icone->setPixmap(QPixmap(":/icones/attention.png"));
        }
        else if (type_icone == IconeNotifications::ICONE_NOTIFICATION_ERREUR)
        {
            ui.lbl_icone->setPixmap(QPixmap(":/icones/invalide.png"));
        }
        else if (type_icone == IconeNotifications::ICONE_NOTIFICATION_VALIDE)
        {
            ui.lbl_icone->setPixmap(QPixmap(":/icones/valide.png"));
        }
        ui.widget_icone->show();
    }

    if (fermeture_auto)
    {
        if (id_timer_fermeture != -1)
        {
            killTimer(id_timer_fermeture);
        }
        id_timer_fermeture = startTimer(texte.length()*100);
        ui.widget_btn_fermer->hide();
    }
    else
    {
        ui.widget_btn_fermer->show();
    }

    ui.lbl_texte->setText(texte);

    if (reference_widget != nullptr)
    {
        if (parent() == Q_NULLPTR)
        {
#ifdef Q_OS_UNIX
            setWindowFlags(Qt::Widget | Qt::FramelessWindowHint | Qt::ToolTip | Qt::WindowStaysOnTopHint);
#else
            setWindowFlags(windowFlags() | Qt::Tool | Qt::FramelessWindowHint);
#endif // Q_OS_UNIX

            setAttribute(Qt::WA_NoSystemBackground);
            setAttribute(Qt::WA_TranslucentBackground);
            setAttribute(Qt::WA_TransparentForMouseEvents);

            QPoint decalage = reference_widget->mapToGlobal(QPoint(100,60));
            move(decalage);
        }
    }
    else
    {
        setWindowFlags(Qt::Widget);
    }

    ui.widget->show();
    show();
}

void WNotifications::MasqueNotification()
{
    ui.widget->hide();
    hide();
}

void WNotifications::ChargeStyleNotifications(const QColor &couleur_fond)
{
    ChargeStyleWidget(this, 3, couleur_fond.name().toStdString().data());
}

void WNotifications::timerEvent(QTimerEvent *event)
{
    if (event->timerId() == id_timer_fermeture)
    {
        killTimer(id_timer_fermeture);
        id_timer_fermeture = -1;
        MasqueNotification();
    }
}

void WNotifications::on_toolButton_clicked()
{
    MasqueNotification();
}
