﻿/**
© Florian Joncour, 2013-2018 florian@zetta-sys.com

Ce logiciel est un programme informatique faisant interface à la bibliothèque
Perspective3D, un outil de modélisation 3D à partir de vues orthographiques 2D.

Ce logiciel est régi par la licence CeCILL-C soumise au droit français et
respectant les principes de diffusion des logiciels libres. Vous pouvez
utiliser, modifier et/ou redistribuer ce programme sous les conditions
de la licence CeCILL-C telle que diffusée par le CEA, le CNRS et l'INRIA
sur le site "http://www.cecill.info".

En contrepartie de l'accessibilité au code source et des droits de copie,
de modification et de redistribution accordés par cette licence, il n'est
offert aux utilisateurs qu'une garantie limitée.  Pour les mêmes raisons,
seule une responsabilité restreinte pèse sur l'auteur du programme,  le
titulaire des droits patrimoniaux et les concédants successifs.

A cet égard  l'attention de l'utilisateur est attirée sur les risques
associés au chargement,  à l'utilisation,  à la modification et/ou au
développement et à la reproduction du logiciel par l'utilisateur étant
donné sa spécificité de logiciel libre, qui peut le rendre complexe à
manipuler et qui le réserve donc à des développeurs et des professionnels
avertis possédant  des  connaissances  informatiques approfondies.  Les
utilisateurs sont donc invités à charger  et  tester  l'adéquation  du
logiciel à leurs besoins dans des conditions permettant d'assurer la
sécurité de leurs systèmes et ou de leurs données et, plus généralement,
à l'utiliser et l'exploiter dans les mêmes conditions de sécurité.

Le fait que vous puissiez accéder à cet en-tête signifie que vous avez
pris connaissance de la licence CeCILL-C, et que vous en avez accepté les
termes.
**/

#ifndef ZCALC_H
#define ZCALC_H

#include <QString>
#include <QObject>

namespace Evaluateur
{
    class EvaluateurExp;
}
class ExtensionLangage;

class Zcalc : public QObject
{
        Q_OBJECT
    public:
        explicit Zcalc(QObject *parent = 0);
        ~Zcalc();

        void Reinit();
        /* Remet à zéro l'interpréteur (toutes les vériables et la pile seront réinitialisés). */

        bool ExecCode(const QString &code);
        /* Exécute le code donné en argument */

        bool ExecFichier(const QString &chemin_script);
        /* Exécute le fichier donné en argument. L'interpréteur n'est pas remis à zéro ! */

        bool ExecCond(const QString &code, bool var_sortie);
        /* Exécute une condition (le code doit contenir une opération booléenne). */

        bool ValideResultat();
        /* Valide le dernier résultat calculé. */

        bool AjoutVariableBool(const QString &var, bool n);
        /* Assigne une variable dans l'évaluateur. */

        bool AjoutVariableInt(const QString &var, int n);
        /* Assigne une variable dans l'évaluateur. */

        bool AjoutVariableFloat(const QString &var, double n);
        /* Assigne une variable dans l'évaluateur. */

        bool ValeurBool(const QString &var, bool &n) const;
        /* Assigne la valeur de la variable donnée en argument sous forme booléenne et renvoi true si la conversion est possible, sinon false. */

        bool ValeurShort(const QString &var, short &n) const;
        /* Assigne la valeur de la variable donnée en argument sous forme entière et renvoi true si la conversion est possible, sinon false. */

        bool ValeurInt(const QString &var, int &n) const;
        /* Assigne la valeur de la variable donnée en argument sous forme entière et renvoi true si la conversion est possible, sinon false. */

        bool ValeurFloat(const QString &var, double &n) const;
        /* Assigne la valeur de la variable donnée en argument sous forme décimale et renvoi true si la conversion est possible, sinon false. */

        QString EncodeValeur(const QString &var) const;
        /* Envoi la valeur encodée sous forme de chaîne de caractères de la variable donnée en argument. */

        void Message(const QString &s);
        /* Message émis par l'évaluateur. */

    signals:
        void Message_sig(const QString &m);

    private:
        Evaluateur::EvaluateurExp *evaluateur;
        ExtensionLangage *extension;
};

#endif // ZCALC_H
