uniform sampler2D Texture;
uniform float Time;
uniform vec3 BackgroundColor;
varying vec2 f_texcoord;

const bool anime_bruit = true;
const bool bruit_monochrome = false;
const float niveau_bruit = 0.35;

vec4 randv2(vec2 co)
{
    if (anime_bruit)
        co += vec2(mod(Time, 10.972), mod(Time, 16.384));

    float br = -(fract(sin(dot(co.xy, vec2(12.9898,78.233))) * 43758.5453));

    if (bruit_monochrome)
        return vec4(br, br, br, 1.0) * niveau_bruit;

    float bruitR =  fract(br)*2.0-1.0;
    float bruitG =  fract(br*1.2154)*2.0-1.0; 
    float bruitB =  fract(br*1.3453)*2.0-1.0;
    float bruitA =  fract(br*1.3647)*2.0-1.0;
    return vec4(bruitR, bruitG, bruitB, bruitA) * niveau_bruit;
}

void main(void)
{
    gl_FragColor = mix(texture2D(Texture, f_texcoord), randv2(f_texcoord), vec4(BackgroundColor, 1));
}
