﻿#include "zwidgets.h"

#include <QCompleter>
#include <QAbstractItemView>
#include <QStringListModel>
#include "animeQt.h"

#ifdef DEBUG
#include <QDebug>
#endif

WExecCommandes::WExecCommandes(QWidget *parent) : QComboBox(parent), completer(0)
{
    setCompleter(0);
    setEditable(true);
    setInsertPolicy(QComboBox::InsertAtBottom);
    setDuplicatesEnabled(false);
    setFocusPolicy(Qt::StrongFocus);
    setMinimumHeight(22);
    setMinimumWidth(150);
    led_cmd = new QLineEdit2(this);
    setLineEdit(led_cmd);

    connect(led_cmd, SIGNAL(focusEvent(bool)), this, SLOT(focusEvent_cmd(bool)));

    QLineEdit *led = lineEdit();
    if (led)
    {
        led->setClearButtonEnabled(true);
        led->setPlaceholderText(tr("Commande"));
    }
}

WExecCommandes::~WExecCommandes()
{
//    if (completer)
//    {
//        delete completer;
//    }
}

void WExecCommandes::defTexteCommande(const QString &cmd)
{
    setCurrentText(cmd);
}

void WExecCommandes::keyPressEvent(QKeyEvent *e)
{
    if (e->key() == Qt::Key_Return || e->key() == Qt::Key_Enter)
    {
        ExecNouvelleCommande(currentText());
        e->accept();
    }
    else if (e->key() == Qt::Key_Escape)
    {
        clearEditText();
        e->accept();
    }
    else
    {
//        if (completer)
//        {
//            completer->complete();
//        }
        QComboBox::keyPressEvent(e);
    }
}

bool WExecCommandes::ajoutCompletion(const QString &commande)
{
    if (completer)
    {
        QStringListModel *model = static_cast<QStringListModel*>(completer->model());

        /* Refuse doublons. */
        QStringList liste_existante = model->stringList();
        for(int i=liste_existante.size()-1; i>=0; --i)
        {
            if (commande.compare(liste_existante[i], Qt::CaseInsensitive) == 0)
            {
//                qDebug() << "ajoutCompletion() :: Refuse doublon : " << commande << " : " << liste_existante[i];
                liste_existante.removeAt(i);
                break;
            }
        }

        model->setStringList(liste_existante << commande);
        return true;
    }
    return false;
}

void WExecCommandes::initCompletion(const QStringList &liste, bool insertion_liste)
{
//    qDebug() << "Nouvelle complétion :: " << liste;

    clear();

    if (insertion_liste)
    {
        const int n = liste.size();
        for(int i=0; i<n; ++i)
        {
            addItem(liste[i]);
        }
    }
    else
    {
        if (completer)
        {
            QStringListModel *model = static_cast<QStringListModel*>(completer->model());
            model->setStringList(liste);
        }
        else
        {
            completer = new QCompleter(liste, this);
            completer->setCaseSensitivity(Qt::CaseSensitive);

//            completer->setCompletionMode(QCompleter::InlineCompletion);
            completer->setCompletionMode(QCompleter::PopupCompletion);

            completer->setFilterMode(Qt::MatchStartsWith);
//            completer->setFilterMode(Qt::MatchContains);

//            completer->setModelSorting(QCompleter::CaseSensitivelySortedModel);
            setCompleter(completer);
        }
    }

    addItem(""); // Toujours une case vide à la fin
}

void WExecCommandes::focusEvent_cmd(bool in)
{
    const bool anim = true;
    if (in)
    {
        if (anim)
        {
            RedimHWidgetAnim(this, 350);
        }
        else
        {
            setMinimumWidth(350);
        }
    }
    else
    {
        if (anim)
        {
            RedimHWidgetAnim(this, 150);
        }
        else
        {
            setMinimumWidth(150);
        }
    }
}

void WExecCommandes::ExecNouvelleCommande(const QString &txt)
{
    setItemText(count()-1, txt);
    addItem("");
    setCurrentIndex(count()-1);
    clearEditText();
    emit NouvelleCommande(txt);
}
